% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsr_plots.R
\name{plot_tsr_metric}
\alias{plot_tsr_metric}
\title{Plot TSR Stats}
\usage{
plot_tsr_metric(experiment, tsr_metrics, plot_type = "violin",
  samples = "all", log2_transform = FALSE, ncol = 1,
  use_cpm = FALSE, ...)
}
\arguments{
\item{experiment}{tsrexplorer object with TSR granges}

\item{tsr_metrics}{Names of metrics in tsrexplorer TSR granges to plot}

\item{plot_type}{Output either a 'violin', 'jitter', 'box', or "boxjitter" plot (default violin)}

\item{samples}{Either 'all' or a vector of sample names to analyze}

\item{log2_transform}{Whether the metric should be log2 transformed prior to plotting}

\item{ncol}{Number of columns to plot data}

\item{use_cpm}{Whether to use the CPM normalized or raw counts}

\item{...}{Arguments passed to ggplot2 plotting functions}
}
\value{
ggplot2 object with tsr metrix plotted
}
\description{
Plot selected TSR stats
}
