% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{plot_correlation}
\alias{plot_correlation}
\title{Plot Sample Correlation}
\usage{
plot_correlation(experiment, data_type = c("tss", "tsr", "features"),
  samples = "all", correlation_plot = "combined",
  correlation_metric = "pearson", log2_transform = TRUE,
  font_size = 4, pt_size = 0.5, ...)
}
\arguments{
\item{experiment}{tsrexplorer object with TMM normalized counts}

\item{data_type}{Whether to make scatter plots from TSS, TSR, or RNA-seq & five-prime data}

\item{samples}{Either 'all' or the names of the samples to plot}

\item{correlation_plot}{Whether to make a correlation 'heatmap', 'scatter', 'combined' or 'hierarchical'}

\item{correlation_metric}{Use either spearman or pearson correlation}

\item{log2_transform}{Should the TMM values be log2+1 transformed prior to plotting?}

\item{font_size}{The font size for the heatmap tiles}

\item{pt_size}{Point size for the scatter plots}

\item{...}{Additional arguments passed to ComplexHeatmap::Heatmap or GGally::ggpairs}
}
\value{
ggplot2 object
}
\description{
heatmaps and/or scatter plots to explore replicate concordance of TSSs or TSRs.
}
