% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/average_plots.R
\name{plot_average}
\alias{plot_average}
\title{Average Plots}
\usage{
plot_average(experiment, data_type = c("tss", "tsr"), samples = "all",
  consider_score = FALSE, upstream = 1000, downstream = 1000,
  threshold = 1, ncol = 1, quantiles = 1, use_cpm = FALSE, ...)
}
\arguments{
\item{experiment}{tsr_explorer object with annotated TSSs}

\item{data_type}{Make average plot for TSS or TSR data}

\item{samples}{Either 'all' to plot all samples, or a vector of sample names}

\item{consider_score}{Should the TSS or TSR score be considered, or just the unique location.}

\item{upstream}{Bases upstream of plot center}

\item{downstream}{Bases downstream of plot center}

\item{threshold}{threshold value for TSSs}

\item{ncol}{Number of columns to use when plotting data when quantiles not set}

\item{quantiles}{Number of quantiles to split data into}

\item{use_cpm}{Whether to use the CPM normalized or raw counts}

\item{...}{Arguments passed to geom_density}
}
\value{
ggplot2 object of average plot
}
\description{
Generate average plots of TSSs or TSRs
}
