% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_tss_plots.R
\name{dominant_tss}
\alias{dominant_tss}
\title{Dominant TSS Average Distance}
\usage{
dominant_tss(experiment, samples = "all", threshold = 1,
  max_upstream = 2000, max_downstream = 500,
  feature_type = c("transcriptId", "geneId"))
}
\arguments{
\item{experiment}{tsrexplorer object with annotated TSSs}

\item{samples}{Either 'all' or name of samples to analyze}

\item{threshold}{Read threshold for TSS}

\item{max_upstream}{Max upstream distance of TSS to consider}

\item{max_downstream}{Max downstream distance of TSS to consider}

\item{feature_type}{Feature that was used to find TSS distance ("geneId", "transcriptId")}
}
\value{
Tibble with dominant TSSs for each gene
}
\description{
Dominant TSS Average Distance
}
