% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gene_plots.R
\name{detect_features}
\alias{detect_features}
\title{Genes/Transcripts Detected}
\usage{
detect_features(experiment, samples = "all", data_type = c("tss",
  "tsr"), feature_type = c("gene", "transcript"), upstream = 1000,
  downstream = 1000, threshold = 1)
}
\arguments{
\item{experiment}{tsrexplorer object with annotated TSSs or TSRs}

\item{samples}{Either 'all' or vector of sample names}

\item{data_type}{Whether TSSs or TSRs should be analyzed}

\item{feature_type}{Whether the TSSs and TSRs were annotated relative to genes or transcripts}

\item{upstream}{Number of bases upstream of annotated TSS to consider as part of promoter}

\item{downstream}{Number of bases downstream of annotated TSS to consider as part of the promoter}

\item{threshold}{The number of reads required in a TSS or TSR to avoid filtering}
}
\value{
tibble of detected feature numbers
}
\description{
Get the number of genes or transcripts detected
}
