% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.R
\name{count_normalization}
\alias{count_normalization}
\title{TMM Normalize TSSs or TSRs}
\usage{
count_normalization(experiment, data_type = c("tss", "tsr", "features"),
  samples = "all", threshold = 1, n_samples = 1)
}
\arguments{
\item{experiment}{tsrexplorer object}

\item{data_type}{Whether TSSs, TSRs, RNA-seq & five-prime feature counts should be normalized}

\item{samples}{Vector with names of samples to include in he normalization}

\item{threshold}{Filter out positions missing at least 'n_samples' number of samples with reads greater than or equal to threshold}

\item{n_samples}{Filter out positions missing at least n_samples number of samples with reads greater than or equal to 'threshold'}
}
\value{
tibble of TMM normalized read counts
}
\description{
Using edgeR to TMM normalize TSSs or TSRs
}
