# TSRbuild: Scripts and workflows for building transcription start regions (TSR) from 5'-mRNA sequence data

The TSRbuild repository encompasses workflows and scripts developed in the
[Brendel](http://brendelgroup.org/) and [Zentner](http://zentnerlab.bio.indiana.edu/)
groups for analyses of transcription start sites (TSS) and regions (TSR) based on
mRNA 5'-end short read sequencing data.
The code conforms to our [RAMOSE](https://brendelgroup.github.io/)
philosophy: it generates __reproducible__, __accurate__, and __meaningful__
results; it is __open__ (source) and designed to be __scalable__ and
__easy__ to use.

The applications discussed here rely on code from our other repositories, in particular

* [GoSTRIPES](https://github.com/BrendelGroup/GoSTRIPES)
* [TSRchitect](https://github.com/BrendelGroup/TSRchitect) (also available as a [Bioconductor](http://bioconductor.org/) package)

The main purpose of the exposition here is to provide examples of complete integration
of different code components to entire reproducible workflows that encompass all analysis
steps from read processing and alignment to determination and visualization of TSS and TSR.

## Quick Start

Please go to the [work](./work) directory and follow the instructions in the
[README](./work/README.md) file.


## Reference

Robert A. Policastro, Daniel J. McDonald, Volker P. Brendel, and Gabriel E. Zentner
(2020) _GoSTRIPES and TSRexploreR: flexible workflows for processing, analysis, and visualization of STRIPE-seq data._
In preparation.


## Contact

Please direct all comments and suggestions to
[Volker Brendel](<mailto:vbrendel@indiana.edu>)
at [Indiana University](http://brendelgroup.org/).
