## Generate a node attribute file of dnLoF-ASD genes in the transition at GW10 for visualization using Cytoscape.

data_gene <- read.table("../gene_set/ID2Symbol.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

data_FC <- read.table("../expression_NPC/FC_vRG_IPC_ASD.txt", sep = "\t", colClasses = "character")

data_FC_1 <- merge(data_gene, data_FC, by = 1)

data_FC_2 <- data_FC_1[,2:ncol(data_FC_1)]

data_FC_2 <- data_FC_2[ do.call(order, data_FC_2) ,]

data_FC_3 <- data.frame(data_FC_2[,1], data_FC_2[,4])

write.table(data_FC_3, file = "FC_vRG_IPC_GW10_ASD.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_FC <- read.table("FC_vRG_IPC_GW10_ASD.txt", sep = "\t", colClasses = "character")

data_FC_1 <- rep("=", nrow(data_FC))

data_FC_2 <- data.frame(data_FC[,1], data_FC_1, data_FC[,2])

write.table("FC", file = "FC_vRG_IPC_GW10_ASD.noa", quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

write.table(data_FC_2, file = "FC_vRG_IPC_GW10_ASD.noa", append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
