## Generate node attribute files of dnMis-Epi genes in six major cell types for visualization using Cytoscape.

library(igraph)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("network_Epi_", ".txt", sep = cell_type[i])

    data_coexpression <- read.table(file_name, sep = "\t", colClasses = "character")

    data_network <- graph.data.frame(data_coexpression, directed = FALSE)

    data_degree <- degree(data_network)

    file_name_1 <- paste("degree_Epi_", ".txt", sep = cell_type[i])

    write.table(data_degree, file = file_name_1, quote = FALSE, sep = "\t", row.names = TRUE, col.names = FALSE)

    data_degree <- read.table(file_name_1, sep = "\t", colClasses = "character")

    data_degree_1 <- rep("=", nrow(data_degree))

    data_degree_2 <- data.frame(data_degree[,1], data_degree_1, data_degree[,2])

    file_name_2 <- paste("GeneDegree_Epi_", ".noa", sep = cell_type[i])

    write.table("GeneDegree", file = file_name_2, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

    write.table(data_degree_2, file = file_name_2, append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
}
