## Generate edge attribute files of dnMis-Epi genes in six major cell types for visualization using Cytoscape.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("network_Epi_", ".txt", sep = cell_type[i])

    data_coexpression <- read.table(file_name, sep = "\t", colClasses = "character")

    data_coexpression_1 <- rep("(pp)", nrow(data_coexpression))

    data_coexpression_2 <- rep("=", nrow(data_coexpression))

    data_coexpression_3 <- rep(cell_type[i], nrow(data_coexpression))

    data_coexpression_4 <- data.frame(data_coexpression[,1], data_coexpression_1, data_coexpression[,2], data_coexpression_2, data_coexpression_3)

    file_name_1 <- paste("CoexpressionType_Epi_", ".eda", sep = cell_type[i])

    write.table("CoexpressionType", file = file_name_1, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

    write.table(data_coexpression_4, file = file_name_1, append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
}
