## Generate a node attribute file of epilepsy genes with dnMis mutations in interneurons for visualization using Cytoscape.

data_gene <- read.table("../gene_set/ID2Symbol.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

data_gene_1 <- read.table("../gene_set/Epi_2_mis.txt", sep = "\t", colClasses = "character")

data_gene_2 <- merge(data_gene, data_gene_1, by = 1)

data_gene_3 <- data_gene_2[,2]

data_gene_3 <- unique(data_gene_3)

data_gene_3 <- sort(data_gene_3)

write.table(data_gene_3, file = "Epi_2_mis.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_1 <- read.table("../gene_set/Epi_1_mis.txt", sep = "\t", colClasses = "character")

data_gene_2 <- merge(data_gene, data_gene_1, by = 1)

data_gene_3 <- data_gene_2[,2]

data_gene_3 <- unique(data_gene_3)

data_gene_3 <- sort(data_gene_3)

write.table(data_gene_3, file = "Epi_1_mis.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- scan("Epi_2_mis.txt", what = "character", sep = "\t")

data_gene_1 <- rep("=", length(data_gene))

data_gene_2 <- rep("mis2", length(data_gene))

data_gene_3 <- data.frame(data_gene, data_gene_1, data_gene_2)

write.table("GeneType", file = "GeneType_Epi.noa", quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

write.table(data_gene_3, file = "GeneType_Epi.noa", append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

data_gene <- scan("Epi_1_mis.txt", what = "character", sep = "\t")

data_gene_1 <- rep("=", length(data_gene))

data_gene_2 <- rep("mis1", length(data_gene))

data_gene_3 <- data.frame(data_gene, data_gene_1, data_gene_2)

write.table(data_gene_3, file = "GeneType_Epi.noa", append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
