## Generate a node attribute file of epilepsy genes with dnMis mutations in interneurons for visualization using Cytoscape.

library(igraph)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 3:3)
{
    file_name <- paste("network_Epi_", ".txt", sep = cell_type[i])

    data_coexpression <- read.table(file_name, sep = "\t", colClasses = "character")

    data_network <- graph.data.frame(data_coexpression, directed = FALSE)

    data_degree <- degree(data_network)

    file_name_1 <- paste("degree_Epi_", ".txt", sep = cell_type[i])

    write.table(data_degree, file = file_name_1, quote = FALSE, sep = "\t", row.names = TRUE, col.names = FALSE)

    data_degree <- read.table(file_name_1, sep = "\t", colClasses = "character")

    data_degree_1 <- rep("=", nrow(data_degree))

    data_degree_2 <- data.frame(data_degree[,1], data_degree_1, data_degree[,2])

    write.table("GeneDegree", file = "GeneDegree_Epi.noa", quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

    write.table(data_degree_2, file = "GeneDegree_Epi.noa", append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
}
