## Generate a node attribute file of ASD genes with dnLoF mutations in NPCs for visualization using Cytoscape.

library(igraph)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:1)
{
    file_name <- paste("network_ASD_", ".txt", sep = cell_type[i])

    data_coexpression <- read.table(file_name, sep = "\t", colClasses = "character")

    data_network <- graph.data.frame(data_coexpression, directed = FALSE)

    data_degree <- degree(data_network)

    file_name_1 <- paste("degree_ASD_", ".txt", sep = cell_type[i])

    write.table(data_degree, file = file_name_1, quote = FALSE, sep = "\t", row.names = TRUE, col.names = FALSE)

    data_degree <- read.table(file_name_1, sep = "\t", colClasses = "character")

    data_degree_1 <- rep("=", nrow(data_degree))

    data_degree_2 <- data.frame(data_degree[,1], data_degree_1, data_degree[,2])

    write.table("GeneDegree", file = "GeneDegree_ASD.noa", quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)

    write.table(data_degree_2, file = "GeneDegree_ASD.noa", append = TRUE, quote = FALSE, sep = " ", row.names = FALSE, col.names = FALSE)
}
