## Generate a co-expression network of epilepsy genes with dnMis mutations in interneurons for visualization using Cytoscape.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 3:3)
{
    file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_gene <- data_expression[,1]

    data_position <- 1:length(data_gene)

    data_position_1 <- data.frame(data_gene, data_position)

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    data_expression_1 <- t(data_expression_1)

    colnames(data_expression_1) <- data_position

    data_coexpression <- cor(data_expression_1, method = "spearman")

    data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

    data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

    data_coexpression_1 <- sort(data_coexpression_1, decreasing = TRUE)

## Calculate co-expression network threshold.

    data_threshold_position <- length(data_coexpression_1)*0.005

    data_threshold_position <- round(data_threshold_position, digits = 0)

    data_threshold <- data_coexpression_1[data_threshold_position]

    data_gene_1 <- read.table("../gene_set/Epi_all_mis.txt", sep = "\t")

    data_position_2 <- merge(data_position_1, data_gene_1, by = 1, sort = FALSE)

    data_position_3 <- data_position_2[,2]

    data_coexpression_2 <- data_coexpression[data_position_3,data_position_3]

    data_gene_1 <- data_position_2[,1]

    file_name_1 <- paste("network_Epi_", "_1.txt", sep = cell_type[i])

    for (j in 1:(nrow(data_coexpression_2)-1))
    {
        for (k in (j+1):nrow(data_coexpression_2))
        {
            data_coexpression_3 <- c(data_gene_1[j], data_gene_1[k], data_coexpression_2[j,k])

            write.table(t(data_coexpression_3), file = file_name_1, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
        }
    }

    data_coexpression_4 <- read.table(file_name_1, sep = "\t")

    data_coexpression_4 <- data_coexpression_4[!is.na(data_coexpression_4[,3]),]

    data_coexpression_4 <- data_coexpression_4[data_coexpression_4[,3]>=data_threshold,]

    file_name_2 <- paste("network_Epi_", "_2.txt", sep = cell_type[i])

    write.table(data_coexpression_4[,1:2], file = file_name_2, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_coexpression <- read.table(file_name_2, sep = "\t", colClasses = "character")

    data_gene <- read.table("../gene_set/ID2Symbol.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

    data_coexpression_1 <- merge(data_coexpression, data_gene, by = 1)

    data_coexpression_2 <- data_coexpression_1[,2:3]

    data_coexpression_3 <- merge(data_coexpression_2, data_gene, by = 1)

    data_coexpression_4 <- data_coexpression_3[,2:3]

    data_coexpression_4 <- data_coexpression_4[ do.call(order, data_coexpression_4) ,]

    file_name <- paste("network_Epi_", "_3.txt", sep = cell_type[i])

    write.table(data_coexpression_4, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_coexpression <- read.table(file_name, sep = "\t", colClasses = "character")

    data_coexpression <- data_coexpression[data_coexpression[,1]!=data_coexpression[,2],]

    data_coexpression_1 <- data_coexpression[data_coexpression[,1]<data_coexpression[,2],]

    data_coexpression_2 <- data_coexpression[data_coexpression[,1]>data_coexpression[,2],]

    data_coexpression_3 <- data_coexpression_2[,2:1]

    file_name <- paste("network_Epi_", "_4.txt", sep = cell_type[i])

    write.table(data_coexpression_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    write.table(data_coexpression_3, file = file_name, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_coexpression_4 <- read.table(file_name, sep = "\t", colClasses = "character")

    data_coexpression_4 <- unique(data_coexpression_4)

    data_coexpression_4 <- data_coexpression_4[ do.call(order, data_coexpression_4) ,]

    file_name_1 <- paste("network_Epi_", ".txt", sep = cell_type[i])

    write.table(data_coexpression_4, file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    write.table(data_coexpression_4, file = "network_Epi_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_coexpression <- read.table("network_Epi_1.txt", sep = "\t", colClasses = "character")

data_coexpression <- unique(data_coexpression)

data_coexpression <- data_coexpression[ do.call(order, data_coexpression) ,]

data_coexpression_1 <- rep("pp", nrow(data_coexpression))

data_coexpression_2 <- data.frame(data_coexpression[,1], data_coexpression_1, data_coexpression[,2])

write.table(data_coexpression_2, file = "network_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
