## Plot overlap between eight NDD gene sets.

library(gplots)

pdf(file = "overlap.pdf", width = 20, height = 20)

par(mar = c(15.5, 15.5, 0.5, 0.5))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

par(bg = 0)

data_overlap_p <- read.table("overlap_p_1.txt", sep = "\t")

data_overlap_p_1 <- matrix(data = 0, nrow = 8, ncol = 8)

data_overlap_p_1[data_overlap_p>=10] <- 4

data_overlap_p_1[(data_overlap_p>=5)&(data_overlap_p<10)] <- 3

data_overlap_p_1[(data_overlap_p>=2)&(data_overlap_p<5)] <- 2

data_overlap_p_1[(data_overlap_p>=1)&(data_overlap_p<2)] <- 1

data_overlap_p_1[data_overlap_p<1] <- 0

data_overlap_p_1 <- t(data_overlap_p_1)

data_overlap_p_1 <- data_overlap_p_1[,ncol(data_overlap_p_1):1]

data_color <- colorpanel(5, "white", "red")

data_overlap_n <- read.table("overlap_n.txt", sep = "\t", colClasses = "character")

data_overlap_p_2 <- read.table("overlap_p_2.txt", sep = "\t", colClasses = "character")

image(1:nrow(data_overlap_p_1), 1:ncol(data_overlap_p_1), data_overlap_p_1, col = data_color, xlab = "", ylab = "", axes = FALSE)

for (i in 1:nrow(data_overlap_n))
{
    for (j in 1:ncol(data_overlap_n))
    {
        if (is.na(data_overlap_p_2[i,j]))
        {
            text(j, 9-i, data_overlap_n[i,j], cex = 3)
        }else
        {
            data_overlap_n[i,j] <- paste(data_overlap_n[i,j], data_overlap_p_2[i,j], sep = "\n(")

            data_overlap_n[i,j] <- paste(data_overlap_n[i,j], ")", sep = "")

            text(j, 9-i, data_overlap_n[i,j], cex = 3)
        }
    }
}

gene_set <- scan("gene_set.txt", what = "character", sep = "\t")

gene_set <- gene_set[1:8]

gene_set_1 <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:length(gene_set), labels = FALSE)

text(1:length(gene_set)-0.4, par("usr")[3]-0.5, labels = gene_set, srt = 45, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:length(gene_set_1), gene_set_1, las = 2)

dev.off()
