## Calculate the minimum gene set size of twelve gene sets in six major cell types.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

gene_set <- scan("gene_set.txt", what = "character", sep = "\t")

file_name <- paste(gene_set[2], ".txt", sep = "")

data_gene <- scan(file_name, what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name_1 <- paste("../expression/", "/gene_1.txt", sep = cell_type[i])

    data_gene_1 <- scan(file_name_1, what = "character", sep = "\t")

    data_overlap <- intersect(data_gene, data_gene_1)

    data_size <- length(data_overlap)

    write.table(data_size, file = "set_size_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
