## Calculate gene set size of twelve gene sets.

data_gene <- scan("../expression/gene_high_1.txt", what = "character", sep = "\t")

gene_set <- scan("gene_set.txt", what = "character", sep = "\t")

for (i in 1:length(gene_set))
{
    file_name <- paste(gene_set[i], ".txt", sep = "")

    data_gene_1 <- scan(file_name, what = "character", sep = "\t")

    data_overlap <- intersect(data_gene, data_gene_1)

    data_size <- length(data_overlap)

    write.table(data_size, file = "set_size.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
