## Divide nonlog2 transformed scRNA-seq data into six major cell types and their developmental stages.

## Divide scRNA-seq data into six major cell types.

data_sample <- read.table("sample_id_7.txt", sep = "\t")

cell_type <- read.table("sample_id_8.txt", sep = "\t")

cell_type <- cell_type[,1]

data_expression <- read.table("../expression/GSE_3.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    data_position <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/GSE_6.txt", sep = cell_type_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Mean expression of genes in six major cell types.

data_sample <- read.table("sample_id_7.txt", sep = "\t")

cell_type <- read.table("sample_id_9.txt", sep = "\t")

cell_type <- cell_type[,1]

data_expression <- read.table("../expression/GSE_3.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    data_position <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Mean expression of genes in cell stages of six major cell types.

data_sample <- read.table("./Astrocytes/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Astrocytes/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Astrocytes/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./Astrocytes/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("./Excitatory neurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Excitatory neurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./Excitatory neurons/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("./Interneurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Interneurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Interneurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./Interneurons/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("./Microglia/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Microglia/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Microglia/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    if (length(data_position)==1)
    {
        data_position <- c(data_position, data_position)
    }

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./Microglia/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("./NPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./NPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./NPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./NPCs/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("./OPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./OPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./OPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./OPCs/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide cell-type-specific scRNA-seq data into developmental stages.

data_sample <- read.table("./Astrocytes/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Astrocytes/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Astrocytes/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Astrocytes/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Excitatory neurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Excitatory neurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Interneurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Interneurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Interneurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Interneurons/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Microglia/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Microglia/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Microglia/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Microglia/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./NPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./NPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./NPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./NPCs/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./OPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./OPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./OPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./OPCs/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
