## Divide NPCs into vRG cells, oRG cells, and IPCs.

## scRNA-seq data.

data_expression <- read.table("../expression/GSE_3.txt", sep = "\t", colClasses = "character")

data_sample <- scan("sample_id_T_4.txt", sep = "\t")

data_sample <- data_sample+1

data_expression_1 <- data.frame(data_expression[,1], data_expression[,data_sample])

write.table(data_expression_1, file = "GSE_T_4.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide scRNA-seq data into six major cell types.

data_sample <- read.table("sample_id_T_7.txt", sep = "\t")

cell_type <- read.table("sample_id_T_8.txt", sep = "\t")

cell_type <- cell_type[,1]

data_expression <- read.table("GSE_T_4.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    data_position <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/GSE_T_6.txt", sep = cell_type_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide NPC scRNA-seq data into subclusters and developmental stages.

data_sample <- read.table("./NPCs/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./NPCs/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./NPCs/GSE_T_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./NPCs/GSE_", ".txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide Excitatory neuron scRNA-seq data into subclusters and developmental stages.

data_sample <- read.table("./Excitatory neurons/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./Excitatory neurons/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_T_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", ".txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## vRG cells at developmental stages.

data_expression_3 <- read.table("./NPCs/GSE_T6_GW08.txt", sep = "\t")

data_expression <- data_expression_3

write.table(data_expression, file = "./vRG/GSE_GW08.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T1_GW09.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T2_GW09.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression, file = "./vRG/GSE_GW09.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T1_GW10.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T2_GW10.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T6_GW10.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_2[,2:ncol(data_expression_2)], data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./vRG/GSE_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_3 <- read.table("./NPCs/GSE_T6_GW12.txt", sep = "\t")

data_expression <- data_expression_3

write.table(data_expression, file = "./vRG/GSE_GW12.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_3 <- read.table("./NPCs/GSE_T6_GW13.txt", sep = "\t")

data_expression <- data_expression_3

write.table(data_expression, file = "./vRG/GSE_GW13.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_3 <- read.table("./NPCs/GSE_T6_GW16.txt", sep = "\t")

data_expression <- data_expression_3

write.table(data_expression, file = "./vRG/GSE_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_3 <- read.table("./NPCs/GSE_T6_GW19.txt", sep = "\t")

data_expression <- data_expression_3

write.table(data_expression, file = "./vRG/GSE_GW19.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T1_GW23.txt", sep = "\t")

data_expression <- data_expression_1

write.table(data_expression, file = "./vRG/GSE_GW23.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## oRG cells at developmental stages.

data_expression_2 <- read.table("./NPCs/GSE_T8_GW09.txt", sep = "\t")

data_expression <- data_expression_2

write.table(data_expression, file = "./oRG/GSE_GW09.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_2 <- read.table("./NPCs/GSE_T8_GW10.txt", sep = "\t")

data_expression <- data_expression_2

write.table(data_expression, file = "./oRG/GSE_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T7_GW16.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T8_GW16.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T9_GW16.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_2[,2:ncol(data_expression_2)], data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./oRG/GSE_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_2 <- read.table("./NPCs/GSE_T8_GW19.txt", sep = "\t")

data_expression <- data_expression_2

write.table(data_expression, file = "./oRG/GSE_GW19.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T7_GW26.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T9_GW26.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./oRG/GSE_GW26.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## IPCs at developmental stages.

data_expression_1 <- read.table("./NPCs/GSE_T3_GW08.txt", sep = "\t")

data_expression <- data_expression_1

write.table(data_expression, file = "./IPCs/GSE_GW08.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW09.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T4_GW09.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T5_GW09.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_2[,2:ncol(data_expression_2)], data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./IPCs/GSE_GW09.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW10.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T4_GW10.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T5_GW10.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_2[,2:ncol(data_expression_2)], data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./IPCs/GSE_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW12.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T5_GW12.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./IPCs/GSE_GW12.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW13.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T5_GW13.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./IPCs/GSE_GW13.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW16.txt", sep = "\t")

data_expression_3 <- read.table("./NPCs/GSE_T5_GW16.txt", sep = "\t")

data_expression <- data.frame(data_expression_1, data_expression_3[,2:ncol(data_expression_3)])

write.table(data_expression, file = "./IPCs/GSE_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW19.txt", sep = "\t")

data_expression <- data_expression_1

write.table(data_expression, file = "./IPCs/GSE_GW19.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression_1 <- read.table("./NPCs/GSE_T3_GW23.txt", sep = "\t")

data_expression <- data_expression_1

write.table(data_expression, file = "./IPCs/GSE_GW23.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Mean expression of genes in vRG cell stages.

data_expression_1 <- read.table("./NPCs/GSE_T3_GW26.txt", sep = "\t")

data_expression <- data_expression_1

write.table(data_expression, file = "./IPCs/GSE_GW26.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- scan("./vRG/sample_id_8.txt", what = "character", sep = "\t")

data_expression <- read.table("./vRG/GSE_GW08.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    file_name <- paste("./vRG/GSE_", ".txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    if (ncol(data_expression)==2)
    {
        data_expression_1 <- data.frame(data_expression_1, data_expression_1)
    }

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./vRG/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Mean expression of genes in oRG cell stages.

cell_type <- scan("./oRG/sample_id_8.txt", what = "character", sep = "\t")

data_expression <- read.table("./oRG/GSE_GW09.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    file_name <- paste("./oRG/GSE_", ".txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    if (ncol(data_expression)==2)
    {
        data_expression_1 <- data.frame(data_expression_1, data_expression_1)
    }

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./oRG/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Mean expression of genes in IPC stages.

cell_type <- scan("./IPCs/sample_id_8.txt", what = "character", sep = "\t")

data_expression <- read.table("./IPCs/GSE_GW08.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    file_name <- paste("./IPCs/GSE_", ".txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    if (ncol(data_expression)==2)
    {
        data_expression_1 <- data.frame(data_expression_1, data_expression_1)
    }

    data_mean <- rowMeans(data_expression_1)

    data_gene <- data.frame(data_gene, data_mean)
}

write.table(data_gene, file = "./IPCs/GSE_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
