## Calculate log2(fold change) values between NPC subtypes.

cell_type <- scan("./oRG/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[1:4]

data_vRG <- read.table("./vRG/GSE_7.txt", sep = "\t")

data_vRG_1 <- data_vRG[,c(3:4, 7:8)]

data_oRG <- read.table("./oRG/GSE_7.txt", sep = "\t")

data_oRG_1 <- data_oRG[,2:5]

data_gene <- data_vRG[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_oRG_1[,i]+1)/(data_vRG_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_vRG_oRG.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- scan("./IPCs/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[1:8]

data_vRG <- read.table("./vRG/GSE_7.txt", sep = "\t")

data_vRG_1 <- data_vRG[,2:9]

data_IPC <- read.table("./IPCs/GSE_7.txt", sep = "\t")

data_IPC_1 <- data_IPC[,2:9]

data_gene <- data_vRG[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_IPC_1[,i]+1)/(data_vRG_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_vRG_IPC.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- scan("./IPCs/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[c(2:3, 6:7, 9)]

data_oRG <- read.table("./oRG/GSE_7.txt", sep = "\t")

data_oRG_1 <- data_oRG[,2:6]

data_IPC <- read.table("./IPCs/GSE_7.txt", sep = "\t")

data_IPC_1 <- data_IPC[,c(3:4, 7:8, 10)]

data_gene <- data_oRG[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_IPC_1[,i]+1)/(data_oRG_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_oRG_IPC.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Calculate log2(fold change) values between NPCs and excitatory neurons.

cell_type <- scan("./Excitatory neurons/sample_id_8.txt", what = "character", sep = "\t")

data_NPC <- read.table("./NPCs/GSE_7.txt", sep = "\t")

data_NPC_1 <- data_NPC[,2:10]

data_Ex <- read.table("./Excitatory neurons/GSE_7.txt", sep = "\t")

data_Ex_1 <- data_Ex[,2:10]

data_gene <- data_NPC[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_Ex_1[,i]+1)/(data_NPC_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_NPC_Ex.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Calculate log2(fold change) values between NPC subtypes and excitatory neurons.

cell_type <- scan("./Excitatory neurons/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[1:8]

data_vRG <- read.table("./vRG/GSE_7.txt", sep = "\t")

data_vRG_1 <- data_vRG[,2:9]

data_Ex <- read.table("./Excitatory neurons/GSE_7.txt", sep = "\t")

data_Ex_1 <- data_Ex[,2:9]

data_gene <- data_vRG[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_Ex_1[,i]+1)/(data_vRG_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_vRG_Ex.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- scan("./Excitatory neurons/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[c(2:3, 6:7, 9)]

data_oRG <- read.table("./oRG/GSE_7.txt", sep = "\t")

data_oRG_1 <- data_oRG[,2:6]

data_Ex <- read.table("./Excitatory neurons/GSE_7.txt", sep = "\t")

data_Ex_1 <- data_Ex[,c(3:4, 7:8, 10)]

data_gene <- data_oRG[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_Ex_1[,i]+1)/(data_oRG_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_oRG_Ex.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- scan("./Excitatory neurons/sample_id_8.txt", what = "character", sep = "\t")

data_IPC <- read.table("./IPCs/GSE_7.txt", sep = "\t")

data_IPC_1 <- data_IPC[,2:10]

data_Ex <- read.table("./Excitatory neurons/GSE_7.txt", sep = "\t")

data_Ex_1 <- data_Ex[,2:10]

data_gene <- data_IPC[,1]

for (i in 1:length(cell_type))
{
    data_FC <- log2((data_Ex_1[,i]+1)/(data_IPC_1[,i]+1))

    data_gene <- data.frame(data_gene, data_FC)
}

write.table(data_gene, file = "FC_IPC_Ex.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
