## Expression change analysis of dnLoF-ASD and dnMis-Epi genes at specific stages of the oRG-to-IPC transitions.

data_gene <- scan("../expression/NPCs/gene_T_1.txt", what = "character", sep = "\t")

data_gene_1 <- scan("../gene_set/dnLoF-ASD.txt", what = "character", sep = "\t")

data_overlap <- intersect(data_gene, data_gene_1)

data_overlap <- sort(data_overlap)

write.table(data_overlap, file = "oRG_IPC_ASD.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene_1 <- scan("../gene_set/dnMis-Epi.txt", what = "character", sep = "\t")

data_overlap <- intersect(data_gene, data_gene_1)

data_overlap <- sort(data_overlap)

write.table(data_overlap, file = "oRG_IPC_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("../expression_nonlog/FC_oRG_IPC.txt", sep = "\t", colClasses = "character")

data_gene <- read.table("oRG_IPC_ASD.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1, file = "FC_oRG_IPC_ASD.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- read.table("oRG_IPC_Epi.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1, file = "FC_oRG_IPC_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- read.table("../expression/NPCs/gene_T_1.txt", sep = "\t", colClasses = "character")

data_expression_1 <- merge(data_expression, data_gene, by = 1)

write.table(data_expression_1, file = "FC_oRG_IPC_all.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
