## Plot expression change of dnLoF-ASD and dnMis-Epi genes in the IPC-to-excitatory neuron differentiation at GW16.

library(ggplot2)

column_name <- c("FC", "Type")

write.table(t(column_name), file = "FC_IPC_Ex_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_FC <- vector(mode = "list", length = 3)

data_expression <- read.table("FC_IPC_Ex_ASD.txt", sep = "\t")

data_expression <- data_expression[,7]

data_gene_set <- rep("dnLoF-ASD", length(data_expression))

data_FC_1 <- data.frame(data_expression, data_gene_set)

write.table(data_FC_1, file = "FC_IPC_Ex_GW16.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_FC[[1]] <- data_expression

data_expression <- read.table("FC_IPC_Ex_Epi.txt", sep = "\t")

data_expression <- data_expression[,7]

data_gene_set <- rep("dnMis-Epi", length(data_expression))

data_FC_1 <- data.frame(data_expression, data_gene_set)

write.table(data_FC_1, file = "FC_IPC_Ex_GW16.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_FC[[2]] <- data_expression

data_expression <- read.table("FC_IPC_Ex_all.txt", sep = "\t")

data_expression <- data_expression[,7]

data_gene_set <- rep("Background", length(data_expression))

data_FC_1 <- data.frame(data_expression, data_gene_set)

write.table(data_FC_1, file = "FC_IPC_Ex_GW16.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_FC[[3]] <- data_expression

data_test <- wilcox.test(data_FC[[1]], data_FC[[3]], alternative = "greater")

data_p <- signif(data_test$p.value, digits = 2)

data_p <- paste("p", data_p, sep = "=")

data_test <- wilcox.test(data_FC[[2]], data_FC[[3]], alternative = "greater")

data_p_1 <- signif(data_test$p.value, digits = 2)

data_p_1 <- paste("p", data_p_1, sep = "=")

data_FC_2 <- read.table("FC_IPC_Ex_GW16.txt", header = TRUE, sep = "\t")

data_plot <- ggplot(data_FC_2, aes(x = factor(Type), y = FC, colour = Type, fill = Type))

data_plot + geom_violin(trim = FALSE) +

        theme_classic() +

        theme(legend.position = "none") +

        scale_colour_manual(values = c("gray60", "purple", "chartreuse3")) +

        scale_fill_manual(values = c("gray60", "purple", "chartreuse3")) +

        stat_summary(fun.y = median, geom = "point", colour = 1, size = 3) +

        scale_x_discrete(limits = c("dnLoF-ASD", "dnMis-Epi", "Background")) +

        scale_y_continuous(breaks = c(-3:3*2), limits = c(-6, 6)) +

        labs(title = "IPCs -> Ex (GW16)", x = "", y = expression("log"[2]*"(fold change, Ex/IPCs)")) +

        theme(axis.text.x = element_text(size = 20, hjust = 1, vjust = 1, angle = 45), axis.text.y = element_text(size = 25)) +

        theme(plot.title = element_text(face = "bold", size = 20), axis.title.y = element_text(size = 25, vjust = 0.4)) +

        geom_segment(aes(x = 1, y = 6-12*0.04, xend = 3, yend = 6-12*0.04), colour = 1) +

        geom_text(x = 2, y = 6, label = data_p, colour = 1, size = 6) +

        geom_segment(aes(x = 2, y = 6-12*0.12, xend = 3, yend = 6-12*0.12), colour = 1) +

        geom_text(x = 2.5, y = 6-12*0.08, label = data_p_1, colour = 1, size = 6) +

        geom_segment(aes(x = 0.5, y = median(data_FC[[3]]), xend = 3.5, yend = median(data_FC[[3]])), colour = 1, linetype = 2)

ggsave(file = "FC_IPC_Ex_GW16.pdf", width = 4, height = 8)
