## Divide scRNA-seq data into six major cell types and their developmental stages.

## Sample data.

data_sample <- read.table("sample_id_6.txt", sep = "\t")

data_sample[,2] <- 1:nrow(data_sample)

write.table(data_sample, file = "sample_id_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- data_sample[,1]

cell_type <- unique(cell_type)

write.table(cell_type, file = "sample_id_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide scRNA-seq data into six major cell types.

data_sample <- read.table("sample_id_7.txt", sep = "\t")

cell_type <- read.table("sample_id_8.txt", sep = "\t")

cell_type <- cell_type[,1]

data_expression <- read.table("GSE_5.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    data_position <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/GSE_6.txt", sep = cell_type_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide sample data into six major cell types.

data_sample <- read.table("sample_id_3.txt", sep = "\t")

cell_type <- read.table("sample_id_8.txt", sep = "\t")

cell_type <- cell_type[,1]

for (i in 1:length(cell_type))
{
    data_GW <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- 1:length(data_GW)

    data_sample_1 <- data.frame(data_GW, data_position)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/sample_id_7.txt", sep = cell_type_1)

    write.table(data_sample_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_GW_1 <- data_sample_1[,1]

    data_GW_1 <- unique(data_GW_1)

    file_name <- paste("./", "/sample_id_8.txt", sep = cell_type_1)

    write.table(data_GW_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide cell-type-specific scRNA-seq data into developmental stages.

data_sample <- read.table("./Astrocytes/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Astrocytes/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Astrocytes/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Astrocytes/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Excitatory neurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Excitatory neurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Interneurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Interneurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Interneurons/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Interneurons/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Microglia/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Microglia/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Microglia/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Microglia/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./NPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./NPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./NPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./NPCs/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./OPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./OPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./OPCs/GSE_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./OPCs/GSE_", ".txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Cell-type-specific scRNA-seq data of cell-type-expressed genes.

data_expression <- read.table("./Astrocytes/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Astrocytes/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Astrocytes/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Excitatory neurons/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Excitatory neurons/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Excitatory neurons/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Interneurons/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Interneurons/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Interneurons/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Microglia/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Microglia/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Microglia/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./NPCs/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./NPCs/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./NPCs/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./OPCs/GSE_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./OPCs/GSE_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./OPCs/gene_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide cell-type-specific scRNA-seq data of cell-type-expressed genes into developmental stages.

data_sample <- read.table("./Astrocytes/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Astrocytes/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Astrocytes/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Astrocytes/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Excitatory neurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Excitatory neurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Interneurons/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Interneurons/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Interneurons/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Interneurons/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./Microglia/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./Microglia/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./Microglia/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./Microglia/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./NPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./NPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./NPCs/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./NPCs/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_sample <- read.table("./OPCs/sample_id_7.txt", sep = "\t")

data_GW <- read.table("./OPCs/sample_id_8.txt", sep = "\t")

data_GW <- data_GW[,1]

data_expression <- read.table("./OPCs/GSE_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_GW))
{
    data_position <- data_sample[data_sample[,1]==data_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_GW_1 <- as.character(data_GW[i])

    file_name <- paste("./OPCs/GSE_", "_high.txt", sep = data_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Genes expressed in at least one major cell type.

data_gene <- scan("./Astrocytes/gene_1.txt", what = "character", sep = "\t")

data_gene_1 <- scan("./Excitatory neurons/gene_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./Interneurons/gene_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./Microglia/gene_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./NPCs/gene_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./OPCs/gene_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene <- sort(data_gene)

write.table(data_gene, file = "gene_high_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
