## Divide six major cell types into cell subclusters.

## Sample data with cell subclusters.

data_sample <- read.table("sample_id_3.txt", sep = "\t")

data_sample[,4] <- 1:nrow(data_sample)

data_sample_1 <- data.frame(data_sample[,3], data_sample[,1:2], data_sample[,4])

write.table(data_sample_1, file = "sample_id_T.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_astrocyte_rf_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,2] <- paste("T", data_sample[,2], sep = "")

write.table(data_sample, file = "sample_id_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_ExcitatoryNeurons_rf_c7_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,2] <- paste("T", data_sample[,2], sep = "")

write.table(data_sample, file = "sample_id_T_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_interneurons_rf_c8_monocle_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,4] <- paste("T", data_sample[,4], sep = "")

data_sample_1 <- data.frame(data_sample[,1], data_sample[,4:5])

write.table(data_sample_1, file = "sample_id_T_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_microglia_rf_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,2] <- paste("T", data_sample[,2], sep = "")

write.table(data_sample, file = "sample_id_T_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_NPCs_rf_c9_monocle_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,4] <- paste("T", data_sample[,4], sep = "")

data_sample_1 <- data.frame(data_sample[,1], data_sample[,4:5])

write.table(data_sample_1, file = "sample_id_T_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("PFC_OPC_rf_c4_ident.txt", sep = "\t", colClasses = "character", skip = 1)

data_sample[,2] <- paste("T", data_sample[,2], sep = "")

write.table(data_sample, file = "sample_id_T_1.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("sample_id_T.txt", sep = "\t", colClasses = "character")

data_sample_1 <- read.table("sample_id_T_1.txt", sep = "\t", colClasses = "character")

data_sample_2 <- merge(data_sample, data_sample_1, by = 1)

data_sample_3 <- data.frame(data_sample_2[,2:3], data_sample_2[,1], data_sample_2[,4:6])

write.table(data_sample_3, file = "sample_id_T_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample <- read.table("sample_id_T_2.txt", sep = "\t", colClasses = "character")

data_sample <- data_sample[ do.call(order, data_sample) ,]

write.table(data_sample, file = "sample_id_T_3.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_sample[,4], file = "sample_id_T_4.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

write.table(data_sample[,1], file = "sample_id_T_5.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_sample_1 <- data.frame(data_sample[,1], data_sample[,4])

write.table(data_sample_1, file = "sample_id_T_6.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## scRNA-seq data.

data_expression <- read.table("GSE_4.txt", sep = "\t", colClasses = "character")

data_sample <- scan("sample_id_T_4.txt", sep = "\t")

data_sample <- data_sample+1

data_expression_1 <- data.frame(data_expression[,1], data_expression[,data_sample])

write.table(data_expression_1, file = "GSE_T_4.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Filtering.

data_expression <- read.table("GSE_T_4.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_expression_1 <- data_expression[data_row>=1,]

write.table(data_expression_1, file = "GSE_T_5.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Sample data.

data_sample <- read.table("sample_id_T_6.txt", sep = "\t")

data_sample[,2] <- 1:nrow(data_sample)

write.table(data_sample, file = "sample_id_T_7.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

cell_type <- data_sample[,1]

cell_type <- unique(cell_type)

write.table(cell_type, file = "sample_id_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide scRNA-seq data into six major cell types.

data_sample <- read.table("sample_id_T_7.txt", sep = "\t")

cell_type <- read.table("sample_id_T_8.txt", sep = "\t")

cell_type <- cell_type[,1]

data_expression <- read.table("GSE_T_5.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(cell_type))
{
    data_position <- data_sample[data_sample[,1]==cell_type[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/GSE_T_6.txt", sep = cell_type_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide sample data into six major cell types.

data_sample <- read.table("sample_id_T_3.txt", sep = "\t")

cell_type <- read.table("sample_id_T_8.txt", sep = "\t")

cell_type <- cell_type[,1]

for (i in 1:length(cell_type))
{
    data_subcluster <- data_sample[data_sample[,1]==cell_type[i],5]

    data_position <- 1:length(data_subcluster)

    data_sample_1 <- data.frame(data_subcluster, data_position)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/sample_id_T_7.txt", sep = cell_type_1)

    write.table(data_sample_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_subcluster_1 <- data_sample_1[,1]

    data_subcluster_1 <- unique(data_subcluster_1)

    data_subcluster_1 <- sort(data_subcluster_1)

    file_name <- paste("./", "/sample_id_T_8.txt", sep = cell_type_1)

    write.table(data_subcluster_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Cell-type-specific scRNA-seq data of cell-type-expressed genes.

data_expression <- read.table("./Astrocytes/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Astrocytes/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Astrocytes/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Excitatory neurons/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Excitatory neurons/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Excitatory neurons/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Interneurons/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Interneurons/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Interneurons/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./Microglia/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./Microglia/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./Microglia/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./NPCs/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./NPCs/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./NPCs/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_expression <- read.table("./OPCs/GSE_T_6.txt", sep = "\t")

data_row <- rowSums(data_expression[,2:ncol(data_expression)]>0)

data_column <- (ncol(data_expression)-1)*0.1

data_expression_1 <- data_expression[data_row>=data_column,]

write.table(data_expression_1, file = "./OPCs/GSE_T_8.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- data_expression_1[,1]

write.table(data_gene, file = "./OPCs/gene_T_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Genes expressed in at least one major cell type.

data_gene <- scan("./Astrocytes/gene_T_1.txt", what = "character", sep = "\t")

data_gene_1 <- scan("./Excitatory neurons/gene_T_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./Interneurons/gene_T_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./Microglia/gene_T_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./NPCs/gene_T_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene_1 <- scan("./OPCs/gene_T_1.txt", what = "character", sep = "\t")

data_gene <- union(data_gene, data_gene_1)

data_gene <- sort(data_gene)

write.table(data_gene, file = "gene_T_high_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
