## Divide NPCs into vRG cells, oRG cells, and IPCs.

## Sample data.

data_sample <- read.table("sample_id_T_3.txt", sep = "\t", colClasses = "character")

data_sample[,5] <- paste(data_sample[,5], data_sample[,2], sep = "_")

write.table(data_sample, file = "sample_id_T_T_3.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide sample data into six major cell types.

data_sample <- read.table("sample_id_T_T_3.txt", sep = "\t")

cell_type <- read.table("sample_id_T_8.txt", sep = "\t")

cell_type <- cell_type[,1]

for (i in 1:length(cell_type))
{
    data_subcluster_GW <- data_sample[data_sample[,1]==cell_type[i],5]

    data_position <- 1:length(data_subcluster_GW)

    data_sample_1 <- data.frame(data_subcluster_GW, data_position)

    cell_type_1 <- as.character(cell_type[i])

    file_name <- paste("./", "/sample_id_T_T_7.txt", sep = cell_type_1)

    write.table(data_sample_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    data_subcluster_GW_1 <- data_sample_1[,1]

    data_subcluster_GW_1 <- unique(data_subcluster_GW_1)

    data_subcluster_GW_1 <- sort(data_subcluster_GW_1)

    file_name <- paste("./", "/sample_id_T_T_8.txt", sep = cell_type_1)

    write.table(data_subcluster_GW_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide NPC scRNA-seq data of NPC-expressed genes into subclusters and developmental stages.

data_sample <- read.table("./NPCs/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./NPCs/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./NPCs/GSE_T_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./NPCs/GSE_", "_high.txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## IPCs at GW10.

data_expression <- read.table("./NPCs/GSE_T3_GW10_high.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T4_GW10_high.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T5_GW10_high.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T3_T4_T5_GW10_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## IPCs at GW16.

data_expression <- read.table("./NPCs/GSE_T3_GW16_high.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T5_GW16_high.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T3_T4_T5_GW16_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## oRG cells at GW10.

data_expression_1 <- read.table("./NPCs/GSE_T8_GW10_high.txt", sep = "\t")

data_expression_3 <- data_expression_1

write.table(data_expression_3, file = "./NPCs/GSE_T7_T8_T9_GW10_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## oRG cells at GW16.

data_expression <- read.table("./NPCs/GSE_T7_GW16_high.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T8_GW16_high.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T9_GW16_high.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T7_T8_T9_GW16_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## vRG cells at GW10.

data_expression <- read.table("./NPCs/GSE_T1_GW10_high.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T2_GW10_high.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T6_GW10_high.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T1_T2_T6_GW10_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## vRG cells at GW16.

data_expression_2 <- read.table("./NPCs/GSE_T6_GW16_high.txt", sep = "\t")

data_expression_3 <- data_expression_2

write.table(data_expression_3, file = "./NPCs/GSE_T1_T2_T6_GW16_high.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide NPC scRNA-seq data into subclusters and developmental stages.

data_sample <- read.table("./NPCs/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./NPCs/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./NPCs/GSE_T_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./NPCs/GSE_", ".txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## IPCs at GW10.

data_expression <- read.table("./NPCs/GSE_T3_GW10.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T4_GW10.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T5_GW10.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T3_T4_T5_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## IPCs at GW16.

data_expression <- read.table("./NPCs/GSE_T3_GW16.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T5_GW16.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T3_T4_T5_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## oRG cells at GW10.

data_expression_1 <- read.table("./NPCs/GSE_T8_GW10.txt", sep = "\t")

data_expression_3 <- data_expression_1

write.table(data_expression_3, file = "./NPCs/GSE_T7_T8_T9_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## oRG cells at GW16.

data_expression <- read.table("./NPCs/GSE_T7_GW16.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T8_GW16.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T9_GW16.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T7_T8_T9_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## vRG cells at GW10.

data_expression <- read.table("./NPCs/GSE_T1_GW10.txt", sep = "\t")

data_expression_1 <- read.table("./NPCs/GSE_T2_GW10.txt", sep = "\t")

data_expression_2 <- read.table("./NPCs/GSE_T6_GW10.txt", sep = "\t")

data_expression_3 <- data.frame(data_expression, data_expression_1[,2:ncol(data_expression_1)], data_expression_2[,2:ncol(data_expression_2)])

write.table(data_expression_3, file = "./NPCs/GSE_T1_T2_T6_GW10.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## vRG cells at GW16.

data_expression_2 <- read.table("./NPCs/GSE_T6_GW16.txt", sep = "\t")

data_expression_3 <- data_expression_2

write.table(data_expression_3, file = "./NPCs/GSE_T1_T2_T6_GW16.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

## Divide Excitatory neuron scRNA-seq data of Excitatory neuron-expressed genes into subclusters and developmental stages.

data_sample <- read.table("./Excitatory neurons/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./Excitatory neurons/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_T_8.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", "_high.txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Divide Excitatory neuron scRNA-seq data into subclusters and developmental stages.

data_sample <- read.table("./Excitatory neurons/sample_id_T_T_7.txt", sep = "\t")

data_subcluster_GW <- read.table("./Excitatory neurons/sample_id_T_T_8.txt", sep = "\t")

data_subcluster_GW <- data_subcluster_GW[,1]

data_expression <- read.table("./Excitatory neurons/GSE_T_6.txt", sep = "\t")

data_gene <- data_expression[,1]

for (i in 1:length(data_subcluster_GW))
{
    data_position <- data_sample[data_sample[,1]==data_subcluster_GW[i],2]

    data_position <- data_position+1

    data_expression_1 <- data_expression[,data_position]

    data_expression_2 <- data.frame(data_gene, data_expression_1)

    data_subcluster_GW_1 <- as.character(data_subcluster_GW[i])

    file_name <- paste("./Excitatory neurons/GSE_", ".txt", sep = data_subcluster_GW_1)

    write.table(data_expression_2, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
