## Calculate cell type size of six major cell types.

cell_type <- scan("sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_size <- ncol(data_expression)-1

    write.table(data_size, file = "sample_size.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Calculate cell type size at specific stages of six major cell types.

cell_type <- scan("sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./", "/sample_id_8.txt", sep = cell_type[i])

    cell_type_1 <- scan(file_name, what = "character", sep = "\t")

    file_name_1 <- paste("./", "/sample_size.txt", sep = cell_type[i])

    for (j in 1:length(cell_type_1))
    {
        file_name_2 <- paste("./", "/GSE_", sep = cell_type[i])

        file_name_2 <- paste(file_name_2, "_high.txt", sep = cell_type_1[j])

        data_expression <- read.table(file_name_2, sep = "\t")

        data_size <- ncol(data_expression)-1

        write.table(data_size, file = file_name_1, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}

## Calculate cell type size during transitions within NPCs at GW10 and GW16.

cell_type <- scan("./transition/sample_id_T.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./transition/GSE_", "_high.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_size <- ncol(data_expression)-1

    write.table(data_size, file = "./transition/sample_size.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Calculate cell type size during differentiation from NPCs to excitatory neurons at GW10 and GW16.

cell_type <- scan("./differentiation/sample_id_T.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./differentiation/GSE_", "_high.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_size <- ncol(data_expression)-1

    write.table(data_size, file = "./differentiation/sample_size.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

## Calculate cell type size during differentiation from NPC subtypes to excitatory neurons at GW10 and GW16.

cell_type <- scan("./differentiation_subtype/sample_id_T.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./differentiation_subtype/GSE_", "_high.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_size <- ncol(data_expression)-1

    write.table(data_size, file = "./differentiation_subtype/sample_size.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
