## Divide the genes expressed in each of six major cell types into ten bins.

data_expression <- read.table("../expression_nonlog/GSE_7.txt", sep = "\t")

cell_type <- scan("sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("./", "/gene_1.txt", sep = cell_type[i])

    data_gene <- read.table(file_name, sep = "\t")

    data_expression_1 <- merge(data_expression, data_gene, by = 1)

    data_expression_2 <- rank(-data_expression_1[,i+1], ties.method = "first")

    data_expression_3 <- data.frame(data_expression_2, data_expression_1[,1])

    data_expression_3 <- data_expression_3[ do.call(order, data_expression_3) ,]

    data_expression_4 <- data_expression_3[,2]

    data_bin <- length(data_expression_4)/10

    data_bin <- round(data_bin, digits = 0)

    file_name_1 <- paste("./", "/gene_bin_1.txt", sep = cell_type[i])

    write.table(data_expression_4[1:data_bin], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_2.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin+1):(data_bin*2)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_3.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*2+1):(data_bin*3)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_4.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*3+1):(data_bin*4)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_5.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*4+1):(data_bin*5)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_6.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*5+1):(data_bin*6)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_7.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*6+1):(data_bin*7)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_8.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*7+1):(data_bin*8)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_9.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*8+1):(data_bin*9)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    file_name_1 <- paste("./", "/gene_bin_10.txt", sep = cell_type[i])

    write.table(data_expression_4[(data_bin*9+1):length(data_expression_4)], file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
