## Co-expression enrichment analysis of dnLoF-ASD and dnMis-Epi genes in the vRG-to-excitatory neuron differentiation at GW16 by downsampling.

cell_type <- scan("../expression/differentiation_subtype/sample_id_T.txt", what = "character", sep = "\t")

cell_type <- cell_type[10]

for (i in 1:length(cell_type))
{
    file_name <- paste("../expression/differentiation_subtype/GSE_", "_high.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_gene <- data_expression[,1]

    data_position <- 1:length(data_gene)

    data_position_1 <- data.frame(data_gene, data_position)

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    file_name_1 <- paste("score_downsample_", ".txt", sep = cell_type[i])

    set.seed(100000000)

    for (j in 1:1000)
    {
        data_column_1 <- sample(1:20, 10)

        data_column_2 <- sample(21:565, 10)

        data_column <- c(data_column_1, data_column_2)

        data_column <- sort(data_column)

        data_expression_2 <- data_expression_1[,data_column]

        data_expression_2 <- t(data_expression_2)

        colnames(data_expression_2) <- data_position

        data_coexpression <- cor(data_expression_2, method = "spearman")

        data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

        data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

        data_coexpression_1 <- sort(data_coexpression_1, decreasing = TRUE)

## Calculate co-expression network threshold.

        data_threshold_position <- length(data_coexpression_1)*0.005

        data_threshold_position <- round(data_threshold_position, digits = 0)

        data_threshold <- data_coexpression_1[data_threshold_position]

## Adjust co-expression network density if there are ties of threshold.

        data_coexpression_2 <- data_coexpression_1[data_coexpression_1>=data_threshold]

        data_adjusted_density <- length(data_coexpression_2)/length(data_coexpression_1)

        gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

        data_score <- numeric(length = length(gene_set))

        for (k in 1:length(gene_set))
        {
            file_name_2 <- paste("../gene_set/", ".txt", sep = gene_set[k])

            data_gene_1 <- read.table(file_name_2, sep = "\t")

            data_position_2 <- merge(data_position_1, data_gene_1, by = 1, sort = FALSE)

            data_position_3 <- data_position_2[,2]

            data_coexpression_3 <- data_coexpression[data_position_3,data_position_3]

            data_coexpression_4 <- data_coexpression_3[upper.tri(data_coexpression_3)]

            data_coexpression_4 <- data_coexpression_4[!is.na(data_coexpression_4)]

## Calculate co-expression fold enrichment score.

            data_coexpression_5 <- data_coexpression_4[data_coexpression_4>=data_threshold]

            data_score[k] <- length(data_coexpression_5)/length(data_coexpression_4)/data_adjusted_density
        }

        write.table(t(data_score), file = file_name_1, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}
