## Plot co-expression enrichment score of dnLoF-ASD and dnMis-Epi genes in vRG cells, IPCs, and the transition at GW10.

pdf(file = "score_GW10_pos005.pdf", width = 6.5, height = 8)

cell_type <- scan("../expression/transition/sample_id_T.txt", what = "character", sep = "\t")

cell_type <- cell_type[1:3]

data_score <- matrix(data = NA, nrow = 2, ncol = length(cell_type))

for (i in 1:length(cell_type))
{
    file_name <- paste("score_", "_005.txt", sep = cell_type[i])

    data_score_1 <- scan(file_name, sep = "\t")

    data_score[,i] <- data_score_1
}

cell_type_1 <- scan("../expression/transition/sample_id_T_1.txt", what = "character", sep = "\t")

cell_type_1 <- cell_type_1[1:3]

data_sample_size <- scan("../expression/transition/sample_size.txt", what = "character", sep = "\t")

data_sample_size <- data_sample_size[1:3]

data_sample_size <- paste("(n=", data_sample_size, sep = "")

data_sample_size <- paste(data_sample_size, ")", sep = "")

gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

par(mar = c(6, 5.5, 4.5, 1))

par(mgp = c(3, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 3)

barplot(data_score, width = 1, space = NULL, names.arg = NULL, beside = TRUE, horiz = FALSE, col = c("purple", "chartreuse3"), main = "NPC transition at GW10", xlab = NULL, ylab = "Co-expression fold enrichment", xlim = NULL, ylim = c(0, 18), axes = FALSE)

par(cex.axis = 2.5)

axis(1, 1:length(cell_type_1)*3-1, labels = FALSE)

text(1:length(cell_type_1)*3-1, par("usr")[3]-0.3, labels = cell_type_1, srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

text(1:length(cell_type_1)*3-1, par("usr")[3]-1.5, labels = data_sample_size, srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

par(cex.axis = 2.5)

axis(2, c(0:9*2), c(0:9*2), line = -0.5, las = 2)

legend(1, 18, gene_set, fill = c("purple", "chartreuse3"), cex = 2.5)

for (i in 1:length(cell_type))
{
    file_name_1 <- paste("density_", "_005.txt", sep = cell_type[i])

    data_density <- read.table(file_name_1, sep = "\t")

    file_name_2 <- paste("background_", "_005.txt", sep = cell_type[i])

    data_background <- scan(file_name_2, sep = "\t")

    data_p <- numeric(length = nrow(data_density))

    for (j in 1:nrow(data_density))
    {
        data_density_background <- matrix(data = NA, nrow = 2, ncol = 2)

        data_density_background[1,1] <- data_density[j,1]

        data_density_background[1,2] <- data_density[j,2]-data_density[j,1]

        data_density_background[2,1] <- data_background[1]

        data_density_background[2,2] <- data_background[2]-data_background[1]

        data_test <- fisher.test(data_density_background, alternative = "greater")

        data_p[j] <- data_test$p.value
    }

    data_p <- -log10(data_p)

    data_p <- round(data_p, digits = 1)

    data_p_1 <- data_p

    data_p_1[data_p>=10] <- "****"

    data_p_1[(data_p>=5)&(data_p<10)] <- "***"

    data_p_1[(data_p>=2)&(data_p<5)] <- "**"

    data_p_1[(data_p>=1)&(data_p<2)] <- "*"

    data_p_1[data_p<1] <- ""

    text(c(i*3-1.5, i*3-0.5), data_score[,i]+0.4, data_p_1, col = 1, cex = 2)
}

dev.off()
