## Plot average Spearmans correlation of dnLoF-ASD and dnMis-Epi genes in vRG cells, oRG cells, IPCs, and their transitions at GW16 by downsampling.

pdf(file = "cor_GW16.pdf", width = 12, height = 8)

cell_type <- scan("../expression/transition/sample_id_T.txt", what = "character", sep = "\t")

cell_type <- cell_type[4:9]

data_cor_1 <- vector(mode = "list", length = length(cell_type))

data_cor_2 <- vector(mode = "list", length = length(cell_type))

i <- 1

data_cor <- scan("cor_vRGs_GW16.txt", sep = "\t")

data_cor_1[[i]] <- data_cor[1]

data_cor_2[[i]] <- data_cor[2]

for (i in 2:length(cell_type))
{
    file_name <- paste("cor_", ".txt", sep = cell_type[i])

    data_cor <- read.table(file_name, sep = "\t")

    data_cor <- t(data_cor)

    data_cor_1[[i]] <- data_cor[,1]

    data_cor_2[[i]] <- data_cor[,2]
}

cell_type_1 <- scan("../expression/transition/sample_id_T_1.txt", what = "character", sep = "\t")

cell_type_1 <- cell_type_1[4:9]

gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

par(mar = c(6.5, 1.5, 4.5, 1.5))

par(mgp = c(-0.5, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 3)

boxplot(data_cor_1, boxwex = 0.3, at = 1:length(cell_type)-0.2, ylim = c(0, 0.3), main = "NPC transition at GW16", ylab = "Average Spearmans correlation", varwidth = FALSE, notch = FALSE, col = "purple", axes = FALSE, outline = FALSE)

boxplot(data_cor_2, add = TRUE, boxwex = 0.3, at = 1:length(cell_type)+0.2, ylim = c(0, 0.3), main = "", ylab = "", varwidth = FALSE, notch = FALSE, col = "chartreuse3", axes = FALSE, outline = FALSE)

points(1-0.2, data_cor_1[[1]], type = "p", pch = 19, col = "purple", cex = 2.5)

points(1+0.2, data_cor_2[[1]], type = "p", pch = 19, col = "chartreuse3", cex = 2.5)

par(cex.axis = 2.5)

axis(1, 1:length(cell_type_1), labels = FALSE)

text(c(1:4, 6), par("usr")[3]-0.01, labels = cell_type_1[c(1:4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

text(5, par("usr")[3]-0.028, labels = cell_type_1[5], srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

text(3.5, par("usr")[3]-0.046, labels = "Downsampling (n=20)", srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

par(cex.axis = 2.5)

axis(2, c(0:3/10), c(0:3/10), line = -4.5, las = 2)

dev.off()
