## Plot expression of dnMis-Epi genes FASN and KMT2B in vRG cells, IPCs, and the transition at GW10.

pdf(file = "expression_Epi_FASN_KMT2B.pdf", width = 10, height = 10)

data_expression <- read.table("../expression/transition/GSE_vRGs_IPCs_GW10_high.txt", sep = "\t")

data_expression_1 <- data_expression[data_expression[,1]==2194,]

data_expression_1 <- data_expression_1[,2:ncol(data_expression_1)]

data_expression_1 <- t(data_expression_1)

data_expression_2 <- data_expression[data_expression[,1]==9757,]

data_expression_2 <- data_expression_2[,2:ncol(data_expression_2)]

data_expression_2 <- t(data_expression_2)

data_rho <- numeric(length = 3)

data_rho[1] <- cor(data_expression_1[1:31], data_expression_2[1:31], method = "spearman")

data_rho[1] <- round(data_rho[1], digits = 2)

data_rho_1 <- numeric(length = 1000)

set.seed(100000000)

for (i in 1:1000)
{
    data_column <- sample(32:82, 31)

    data_column <- sort(data_column)

    data_rho_1[i] <- cor(data_expression_1[data_column], data_expression_2[data_column], method = "spearman")
}

data_rho[2] <- round(mean(data_rho_1), digits = 2)

data_rho_1 <- numeric(length = 1000)

set.seed(100000000)

for (i in 1:500)
{
    data_column_1 <- sample(1:31, 15)

    data_column_2 <- sample(32:82, 16)

    data_column <- c(data_column_1, data_column_2)

    data_column <- sort(data_column)

    data_rho_1[i] <- cor(data_expression_1[data_column], data_expression_2[data_column], method = "spearman")
}

for (i in 501:1000)
{
    data_column_1 <- sample(1:31, 16)

    data_column_2 <- sample(32:82, 15)

    data_column <- c(data_column_1, data_column_2)

    data_column <- sort(data_column)

    data_rho_1[i] <- cor(data_expression_1[data_column], data_expression_2[data_column], method = "spearman")
}

data_rho[3] <- round(mean(data_rho_1), digits = 2)

par(mar = c(6, 6, 4.5, 1))

par(mgp = c(3.5, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 3)

plot(data_expression_1, data_expression_2, type = "p", pch = 19, xlim = c(0, 12), ylim = c(0, 10), main = "vRG -> IPCs (GW10)", xlab = expression("FASN expression (log"[2]*"(TPM+1))"), ylab = expression("KMT2B expression (log"[2]*"(TPM+1))"), col = "gray50", cex = 1, axes = FALSE)

points(data_expression_1[1:31], data_expression_2[1:31], type = "p", pch = 19, col = "gray50", cex = 2)

points(data_expression_1[32:82], data_expression_2[32:82], type = "p", pch = 19, col = "orange", cex = 2)

axis(1, c(0:6*2), c(0:6*2), las = 1)

axis(2, c(0:5*2), c(0:5*2), las = 2)

text(11, 10, "vRG+IPCs", cex = 2.5, col = 1)

data_rho_1 <- paste("rho", data_rho[3], sep = "=")

text(11, 9.5, data_rho_1, cex = 2.5, col = 1)

text(11, 9, "IPCs", cex = 2.5, col = "orange")

data_rho_1 <- paste("rho", data_rho[2], sep = "=")

text(11, 8.5, data_rho_1, cex = 2.5, col = "orange")

text(11, 8, "vRG", cex = 2.5, col = "gray50")

data_rho_1 <- paste("rho", data_rho[1], sep = "=")

text(11, 7.5, data_rho_1, cex = 2.5, col = "gray50")

dev.off()
