## Plot co-expression enrichment score of dnLoF-ASD and dnMis-Epi genes at specific stages of interneurons by downsampling.

pdf(file = "score_downsample_In.pdf", width = 6.5, height = 8)

cell_type <- scan("../expression/Interneurons/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[c(5, 7:8)]

data_score_1 <- vector(mode = "list", length = length(cell_type))

data_score_2 <- vector(mode = "list", length = length(cell_type))

data_score_3 <- numeric(length = length(cell_type))

data_score_4 <- numeric(length = length(cell_type))

for (i in 1:length(cell_type))
{
    file_name <- paste("score_downsample_In_", ".txt", sep = cell_type[i])

    data_score <- read.table(file_name, sep = "\t")

    data_score_1[[i]] <- data_score[,1]

    data_score_2[[i]] <- data_score[,2]

    data_score_3[i] <- mean(data_score_1[[i]])

    data_score_4[i] <- mean(data_score_2[[i]])
}

gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

par(mar = c(6, 2.5, 4.5, 1))

par(mgp = c(0, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 3)

boxplot(data_score_1, boxwex = 0.3, at = 1:length(cell_type)-0.2, ylim = c(0, 12), main = "Interneurons", ylab = "Co-expression fold enrichment", varwidth = FALSE, notch = FALSE, col = "purple", axes = FALSE, outline = FALSE)

boxplot(data_score_2, add = TRUE, boxwex = 0.3, at = 1:length(cell_type)+0.2, ylim = c(0, 12), main = "", ylab = "", varwidth = FALSE, notch = FALSE, col = "chartreuse3", axes = FALSE, outline = FALSE)

par(cex.axis = 2.5)

axis(1, 1:length(cell_type), labels = FALSE)

text(1:length(cell_type), par("usr")[3]-0.3, labels = cell_type, srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

text(2, par("usr")[3]-1.2, labels = "Downsampling (n=50)", srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

par(cex.axis = 2.5)

axis(2, c(0:6*2), c(0:6*2), line = -3.5, las = 2)

for (i in 1:length(cell_type))
{
    file_name_1 <- paste("density_In_", "_005.txt", sep = cell_type[i])

    data_density <- read.table(file_name_1, sep = "\t")

    file_name_2 <- paste("background_In_", "_005.txt", sep = cell_type[i])

    data_background <- scan(file_name_2, sep = "\t")

    data_density[1,1] <- data_score_3[i]*data_density[1,2]*data_background[1]/data_background[2]

    data_density[1,1] <- round(data_density[1,1], digits = 0)

    data_density_background <- matrix(data = NA, nrow = 2, ncol = 2)

    data_density_background[1,1] <- data_density[1,1]

    data_density_background[1,2] <- data_density[1,2]-data_density[1,1]

    data_density_background[2,1] <- data_background[1]

    data_density_background[2,2] <- data_background[2]-data_background[1]

    data_test <- fisher.test(data_density_background, alternative = "greater")

    data_p <- data_test$p.value

    data_p <- -log10(data_p)

    data_p_1 <- data_p

    data_p_1[data_p>=10] <- "****"

    data_p_1[(data_p>=5)&(data_p<10)] <- "***"

    data_p_1[(data_p>=2)&(data_p<5)] <- "**"

    data_p_1[(data_p>=1)&(data_p<2)] <- "*"

    data_p_1[data_p<1] <- ""

    text(i-0.2, 12, data_p_1, col = 1, cex = 2)
}

for (i in 1:length(cell_type))
{
    file_name_1 <- paste("density_In_", "_005.txt", sep = cell_type[i])

    data_density <- read.table(file_name_1, sep = "\t")

    file_name_2 <- paste("background_In_", "_005.txt", sep = cell_type[i])

    data_background <- scan(file_name_2, sep = "\t")

    data_density[2,1] <- data_score_4[i]*data_density[2,2]*data_background[1]/data_background[2]

    data_density[2,1] <- round(data_density[2,1], digits = 0)

    data_density_background <- matrix(data = NA, nrow = 2, ncol = 2)

    data_density_background[1,1] <- data_density[2,1]

    data_density_background[1,2] <- data_density[2,2]-data_density[2,1]

    data_density_background[2,1] <- data_background[1]

    data_density_background[2,2] <- data_background[2]-data_background[1]

    data_test <- fisher.test(data_density_background, alternative = "greater")

    data_p <- data_test$p.value

    data_p <- -log10(data_p)

    data_p_1 <- data_p

    data_p_1[data_p>=10] <- "****"

    data_p_1[(data_p>=5)&(data_p<10)] <- "***"

    data_p_1[(data_p>=2)&(data_p<5)] <- "**"

    data_p_1[(data_p>=1)&(data_p<2)] <- "*"

    data_p_1[data_p<1] <- ""

    text(i+0.2, 11, data_p_1, col = 1, cex = 2)
}

dev.off()
