## Plot average Spearmans correlation of dnLoF-ASD and dnMis-Epi genes at specific stages of NPCs by downsampling.

pdf(file = "cor_NPC.pdf", width = 6.5, height = 8)

cell_type <- scan("../expression/NPCs/sample_id_8.txt", what = "character", sep = "\t")

cell_type <- cell_type[c(2:3, 6)]

data_cor_1 <- vector(mode = "list", length = length(cell_type))

data_cor_2 <- vector(mode = "list", length = length(cell_type))

i <- 1

data_cor <- scan("cor_NPC_GW09.txt", sep = "\t")

data_cor_1[[i]] <- data_cor[1]

data_cor_2[[i]] <- data_cor[2]

for (i in 2:length(cell_type))
{
    file_name <- paste("cor_NPC_", ".txt", sep = cell_type[i])

    data_cor <- read.table(file_name, sep = "\t")

    data_cor <- t(data_cor)

    data_cor_1[[i]] <- data_cor[,1]

    data_cor_2[[i]] <- data_cor[,2]
}

gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

par(mar = c(6, 3, 4.5, 1))

par(mgp = c(0.5, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 3)

boxplot(data_cor_1, boxwex = 0.3, at = 1:length(cell_type)-0.2, ylim = c(0, 0.3), main = "NPCs", ylab = "Average Spearmans correlation", varwidth = FALSE, notch = FALSE, col = "purple", axes = FALSE, outline = FALSE)

boxplot(data_cor_2, add = TRUE, boxwex = 0.3, at = 1:length(cell_type)+0.2, ylim = c(0, 0.3), main = "", ylab = "", varwidth = FALSE, notch = FALSE, col = "chartreuse3", axes = FALSE, outline = FALSE)

points(1-0.2, data_cor_1[[1]], type = "p", pch = 19, col = "purple", cex = 2.5)

points(1+0.2, data_cor_2[[1]], type = "p", pch = 19, col = "chartreuse3", cex = 2.5)

par(cex.axis = 2.5)

axis(1, 1:length(cell_type), labels = FALSE)

text(1:length(cell_type), par("usr")[3]-0.01, labels = cell_type, srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

text(2, par("usr")[3]-0.035, labels = "Downsampling (n=50)", srt = 0, pos = 1, xpd = TRUE, cex = 2.5)

par(cex.axis = 2.5)

axis(2, c(0:3/10), c(0:3/10), line = -3.5, las = 2)

dev.off()
