## Spearmans correlation analysis of dnLoF-ASD and dnMis-Epi genes in NPCs at GW10.

cell_type <- scan("../expression/differentiation/sample_id_T.txt", what = "character", sep = "\t")

cell_type <- cell_type[1]

for (i in 1:length(cell_type))
{
    file_name <- paste("../expression/differentiation/GSE_", "_high.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    gene_set <- scan("../gene_set/gene_set_2.txt", what = "character", sep = "\t")

    file_name_1 <- paste("cor_", ".txt", sep = cell_type[i])

    for (j in 1:length(gene_set))
    {
        file_name_2 <- paste("../gene_set/", ".txt", sep = gene_set[j])

        data_gene <- read.table(file_name_2, sep = "\t")

        data_expression_1 <- merge(data_expression, data_gene, by = 1)

        data_expression_2 <- data_expression_1[,2:ncol(data_expression_1)]

        data_expression_2 <- t(data_expression_2)

        data_coexpression <- cor(data_expression_2, method = "spearman")

        data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

        data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

        data_cor <- mean(data_coexpression_1)

        write.table(data_cor, file = file_name_1, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}
