## Plot co-expression enrichment score of eight NDD gene sets and four control gene sets in six major cortical cell types at co-expression threshold 0.25%.

pdf(file = "score_threshold_0025.pdf", width = 16.5, height = 20)

par(mar = c(8, 17.5, 4.5, 0))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

data_position <- matrix(data = NA, nrow = 12, ncol = 2)

data_position[,1] <- 6

data_position[,2] <- 12:1

data_score <- scan("score_threshold_Microglia_0025.txt", sep = "\t")

plot(data_position, type = "p", pch = 19, xlim = c(0.5, 6.5), ylim = c(0.5, 12.5), main = "Co-expression fold enrichment (0.25%)", xlab = "", ylab = "", col = "orange", cex = data_score, axes = FALSE)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 5

data_score <- scan("score_threshold_OPCs_0025.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "hotpink", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 4

data_score <- scan("score_threshold_Astrocytes_0025.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "cyan3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 3

data_score <- scan("score_threshold_Interneurons_0025.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "royalblue3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 2

data_score <- scan("score_threshold_Excitatory neurons_0025.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "darkgreen", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 1

data_score <- scan("score_threshold_NPCs_0025.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = 2, cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

cell_type <- scan("../expression/sample_id_10.txt", what = "character", sep = "\t")

gene_set <- c("dnLoF-ASD", "dnLoF-Epi", "dnLoF-ID", "dnLoF-DD", "dnMis-ASD", "dnMis-Epi", "dnMis-ID", "dnMis-DD", "ASD siblings", "ExAC controls", "Brain-GRF", "Synapse")

gene_set <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:6, labels = FALSE)

text(c(1, 3, 5), par("usr")[3]-0.05, labels = cell_type[c(1, 3, 5)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2, 4, 6), par("usr")[3]-0.35, labels = cell_type[c(2, 4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2), par("usr")[3]-0.6, labels = "neurons", srt = 0, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:12, gene_set, las = 2)

dev.off()

## Plot co-expression enrichment score of eight NDD gene sets and four control gene sets in six major cortical cell types at co-expression threshold 0.5%.

pdf(file = "score_threshold_005.pdf", width = 16.5, height = 20)

par(mar = c(8, 17.5, 4.5, 0))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

data_position <- matrix(data = NA, nrow = 12, ncol = 2)

data_position[,1] <- 6

data_position[,2] <- 12:1

data_score <- scan("score_threshold_Microglia_005.txt", sep = "\t")

plot(data_position, type = "p", pch = 19, xlim = c(0.5, 6.5), ylim = c(0.5, 12.5), main = "Co-expression fold enrichment (0.5%)", xlab = "", ylab = "", col = "orange", cex = data_score, axes = FALSE)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 5

data_score <- scan("score_threshold_OPCs_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "hotpink", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 4

data_score <- scan("score_threshold_Astrocytes_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "cyan3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 3

data_score <- scan("score_threshold_Interneurons_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "royalblue3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 2

data_score <- scan("score_threshold_Excitatory neurons_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "darkgreen", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 1

data_score <- scan("score_threshold_NPCs_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = 2, cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

cell_type <- scan("../expression/sample_id_10.txt", what = "character", sep = "\t")

gene_set <- c("dnLoF-ASD", "dnLoF-Epi", "dnLoF-ID", "dnLoF-DD", "dnMis-ASD", "dnMis-Epi", "dnMis-ID", "dnMis-DD", "ASD siblings", "ExAC controls", "Brain-GRF", "Synapse")

gene_set <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:6, labels = FALSE)

text(c(1, 3, 5), par("usr")[3]-0.05, labels = cell_type[c(1, 3, 5)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2, 4, 6), par("usr")[3]-0.35, labels = cell_type[c(2, 4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2), par("usr")[3]-0.6, labels = "neurons", srt = 0, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:12, gene_set, las = 2)

dev.off()

## Plot co-expression enrichment score of eight NDD gene sets and four control gene sets in six major cortical cell types at co-expression threshold 1%.

pdf(file = "score_threshold_01.pdf", width = 16.5, height = 20)

par(mar = c(8, 17.5, 4.5, 0))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

data_position <- matrix(data = NA, nrow = 12, ncol = 2)

data_position[,1] <- 6

data_position[,2] <- 12:1

data_score <- scan("score_threshold_Microglia_01.txt", sep = "\t")

plot(data_position, type = "p", pch = 19, xlim = c(0.5, 6.5), ylim = c(0.5, 12.5), main = "Co-expression fold enrichment (1%)", xlab = "", ylab = "", col = "orange", cex = data_score, axes = FALSE)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 5

data_score <- scan("score_threshold_OPCs_01.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "hotpink", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 4

data_score <- scan("score_threshold_Astrocytes_01.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "cyan3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 3

data_score <- scan("score_threshold_Interneurons_01.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "royalblue3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 2

data_score <- scan("score_threshold_Excitatory neurons_01.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "darkgreen", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 1

data_score <- scan("score_threshold_NPCs_01.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = 2, cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

cell_type <- scan("../expression/sample_id_10.txt", what = "character", sep = "\t")

gene_set <- c("dnLoF-ASD", "dnLoF-Epi", "dnLoF-ID", "dnLoF-DD", "dnMis-ASD", "dnMis-Epi", "dnMis-ID", "dnMis-DD", "ASD siblings", "ExAC controls", "Brain-GRF", "Synapse")

gene_set <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:6, labels = FALSE)

text(c(1, 3, 5), par("usr")[3]-0.05, labels = cell_type[c(1, 3, 5)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2, 4, 6), par("usr")[3]-0.35, labels = cell_type[c(2, 4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2), par("usr")[3]-0.6, labels = "neurons", srt = 0, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:12, gene_set, las = 2)

dev.off()
