## Plot co-expression enrichment score of eight NDD gene sets and four control gene sets in six major cortical cell types by controlling for gene set size.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("score_gene_", ".txt", sep = cell_type[i])

    data_score <- read.table(file_name, sep = "\t")

    data_score_1 <- rowMeans(data_score)

    file_name <- paste("score_gene_", "_1.txt", sep = cell_type[i])

    write.table(data_score_1, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

pdf(file = "score_gene.pdf", width = 16.5, height = 20)

par(mar = c(8, 17.5, 4.5, 0))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

data_position <- matrix(data = NA, nrow = 12, ncol = 2)

data_position[,1] <- 6

data_position[,2] <- 12:1

data_score <- scan("score_gene_Microglia_1.txt", sep = "\t")

plot(data_position, type = "p", pch = 19, xlim = c(0.5, 6.5), ylim = c(0.5, 12.5), main = "\nCo-expression fold enrichment\n(controlling for gene set size)", xlab = "", ylab = "", col = "orange", cex = data_score, axes = FALSE)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 5

data_score <- scan("score_gene_OPCs_1.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "hotpink", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 4

data_score <- scan("score_gene_Astrocytes_1.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "cyan3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 3

data_score <- scan("score_gene_Interneurons_1.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "royalblue3", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 2

data_score <- scan("score_gene_Excitatory neurons_1.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "darkgreen", cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

data_position[,1] <- 1

data_score <- scan("score_gene_NPCs_1.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = 2, cex = data_score)

data_score_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_1, cex = 3)

cell_type <- scan("../expression/sample_id_10.txt", what = "character", sep = "\t")

gene_set <- scan("../gene_set/gene_set.txt", what = "character", sep = "\t")

data_set_size <- scan("../gene_set/set_size.txt", what = "character", sep = "\t")

gene_set <- paste("\n", gene_set, sep = "")

gene_set <- paste(gene_set, data_set_size, sep = "\n(")

gene_set <- paste(gene_set, ")", sep = "")

gene_set <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:6, labels = FALSE)

text(c(1, 3, 5), par("usr")[3]-0.05, labels = cell_type[c(1, 3, 5)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2, 4, 6), par("usr")[3]-0.35, labels = cell_type[c(2, 4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2), par("usr")[3]-0.6, labels = "neurons", srt = 0, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:12, gene_set, las = 2)

dev.off()
