## Plot co-expression enrichment score of dnMis-Epi genes in Interneurons using 17 measures of association implemented in the dismay R package.

pdf(file = "score_In.pdf", width = 8, height = 8)

data_metric <- c("spearman", "pearson", "kendall", "zi_kendall", "bicor", "weighted_rank", "binomial", "MI", "cosine", "jaccard", "euclidean", "canberra", "manhattan", "hamming", "dice", "phi_s", "rho_p")

data_score <- numeric(length = length(data_metric))

for (i in 1:length(data_metric))
{
    file_name <- paste("score_In_", "_005.txt", sep = data_metric[i])

    data_score_1 <- scan(file_name, sep = "\t")

    data_score[i] <- data_score_1[6]
}

par(mar = c(10, 5.5, 4.5, 0))

par(mgp = c(3, 1, 0))

par(cex.axis = 2)

par(cex.lab = 2)

par(cex.main = 2.5)

barplot(data_score, width = 1, space = NULL, names.arg = NULL, beside = TRUE, horiz = FALSE, col = rainbow(length(data_metric)), main = "Epi, interneurons", xlab = NULL, ylab = "Co-expression fold enrichment", xlim = NULL, ylim = c(0, 30), axes = FALSE)

par(cex.axis = 1.5)

axis(1, 1:length(data_metric)*1.2-0.5, data_metric, las = 2)

par(cex.axis = 2)

axis(2, c(0:6*5), c(0:6*5), las = 2)

dev.off()
