## Plot co-expression enrichment score of GO biological process terms in NPCs calculated using Spearmans correlation and proportionality phi_s.

pdf(file = "score_GO_NPCs.pdf", width = 15, height = 10)

data_GO <- scan("GO_NPCs.txt", what = "character", sep = "\t")

data_score <- read.table("score_GO_NPCs.txt", sep = "\t")

data_score <- t(data_score)

par(mar = c(25.5, 4, 4.5, 0))

par(mgp = c(2, 1, 0))

par(cex.axis = 2)

par(cex.lab = 2)

par(cex.main = 2.5)

barplot(data_score, width = 1, space = NULL, names.arg = NULL, beside = TRUE, horiz = FALSE, col = c(2, "darkgreen"), main = "NPCs", xlab = NULL, ylab = "Co-expression fold enrichment", xlim = NULL, ylim = c(0, 50), axes = FALSE)

par(cex.axis = 1.2)

axis(1, 1:length(data_GO)*3-1, data_GO, las = 2)

par(cex.axis = 2)

axis(2, c(0:5*10), c(0:5*10), line = -1.5, las = 2)

legend(1, 50, c("Spearman", "phi_s"), fill = c(2, "darkgreen"), cex = 2)

dev.off()
