## Plot co-expression enrichment score of ASD and DD gene sets with dnMis mutations and those with severe dnMis mutations (CADD>25) in six major cortical cell types.

pdf(file = "score_CADD_005.pdf", width = 19, height = 10)

par(mar = c(8, 28, 4.5, 0))

par(mgp = c(3, 1.5, 0))

par(cex.axis = 2.5)

par(cex.lab = 2.5)

par(cex.main = 4)

data_position <- matrix(data = NA, nrow = 4, ncol = 2)

data_position[,1] <- 6

data_position[,2] <- 4:1

data_score <- scan("score_CADD_Microglia_005.txt", sep = "\t")

plot(data_position, type = "p", pch = 19, xlim = c(0.5, 6.5), ylim = c(0.5, 4.5), main = "\nCo-expression fold enrichment\n(controlling for missense severity)", xlab = "", ylab = "", col = "orange", cex = data_score, axes = FALSE)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

data_position[,1] <- 5

data_score <- scan("score_CADD_OPCs_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "hotpink", cex = data_score)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

data_position[,1] <- 4

data_score <- scan("score_CADD_Astrocytes_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "cyan3", cex = data_score)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

data_position[,1] <- 3

data_score <- scan("score_CADD_Interneurons_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "royalblue3", cex = data_score)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

data_position[,1] <- 2

data_score <- scan("score_CADD_Excitatory neurons_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = "darkgreen", cex = data_score)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

data_position[,1] <- 1

data_score <- scan("score_CADD_NPCs_005.txt", sep = "\t")

points(data_position, type = "p", pch = 19, col = 2, cex = data_score)

data_score_CADD_1 <- round(data_score, digits = 1)

text(data_position[,1], data_position[,2]-sqrt(data_score)/8, data_score_CADD_1, cex = 3)

cell_type <- scan("../expression/sample_id_10.txt", what = "character", sep = "\t")

gene_set <- c("dnMis-ASD", "dnMis-ASD, CADD>25", "dnMis-DD", "dnMis-DD, CADD>25")

data_set_size <- scan("../gene_set/set_size_CADD.txt", what = "character", sep = "\t")

gene_set <- paste("\n", gene_set, sep = "")

gene_set <- paste(gene_set, data_set_size, sep = "\n(")

gene_set <- paste(gene_set, ")", sep = "")

gene_set <- gene_set[length(gene_set):1]

par(cex.axis = 3)

axis(1, 1:6, labels = FALSE)

text(c(1, 3, 5), par("usr")[3]-0.05, labels = cell_type[c(1, 3, 5)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2, 4, 6), par("usr")[3]-0.35, labels = cell_type[c(2, 4, 6)], srt = 0, pos = 1, xpd = TRUE, cex = 3)

text(c(2), par("usr")[3]-0.6, labels = "neurons", srt = 0, pos = 1, xpd = TRUE, cex = 3)

par(cex.axis = 3)

axis(2, 1:4, gene_set, las = 2)

dev.off()
