## Plot co-expression enrichment score of dnLoF-ASD genes in NPCs at varying co-expression thresholds.

pdf(file = "score_ASD.pdf", width = 10, height = 5)

data_score <- read.table("score_ASD.txt", sep = "\t")

par(mar = c(5, 7, 4.5, 1))

par(mgp = c(3, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2)

par(cex.main = 2.5)

plot(1:nrow(data_score), data_score[,2], type = "p", pch = 19, xlim = c(1, nrow(data_score)), ylim = c(0, 20), main = "ASD, NPCs", xlab = "Co-expression threshold (top percentage %)", ylab = "Co-expression\nfold enrichment", col = "gray30", cex = 2, axes = FALSE)

points(5, data_score[5,2], type = "p", pch = 19, col = 2, cex = 2)

par(cex.axis = 1.6)

axis(1, 1:nrow(data_score), data_score[,1]*100, las = 1)

par(cex.axis = 2)

axis(2, c(0:5*4), c(0:5*4), las = 2)

dev.off()
