## Plot sample size of six major cortical cell types.

pdf(file = "sample_size.pdf", width = 16.5, height = 8)

data_sample_size <- scan("../expression/sample_size.txt", sep = "\t")

data_sample_size <- -data_sample_size

par(mar = c(2, 12, 2, 0))

par(mgp = c(8, 1, 0))

par(cex.axis = 4)

par(cex.lab = 4)

par(cex.main = 4)

barplot(data_sample_size, width = 1, space = 2, names.arg = NULL, beside = TRUE, horiz = FALSE, col = c(2, "darkgreen", "royalblue3", "cyan3", "hotpink", "orange"), main = "", xlab = NULL, ylab = "Sample size", xlim = NULL, ylim = c(-1100, 0), axes = FALSE)

par(cex.axis = 4)

axis(2, c(-5:0*200), c(5:0*200), las = 1)

dev.off()
