## Plot P values of pairwise co-expression fold enrichment comparison between eight NDD gene sets in six major cortical cell types.

library(gplots)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("density_", "_005.txt", sep = cell_type[i])

    data_density <- read.table(file_name, sep = "\t")

    data_p <- matrix(data = NA, nrow = nrow(data_density), ncol = nrow(data_density))

    for (j in 1:nrow(data_density))
    {
        for (k in 1:nrow(data_density))
        {
            if (j!=k)
            {
                data_density_1 <- matrix(data = NA, nrow = 2, ncol = 2)

                data_density_1[1,1] <- data_density[j,1]

                data_density_1[1,2] <- data_density[j,2]-data_density[j,1]

                data_density_1[2,1] <- data_density[k,1]

                data_density_1[2,2] <- data_density[k,2]-data_density[k,1]

                data_test <- fisher.test(data_density_1, alternative = "greater")

                data_p[j,k] <- data_test$p.value
            }
        }
    }

    file_name <- paste("p_", "_005.txt", sep = cell_type[i])

    write.table(data_p, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

for (i in 1:length(cell_type))
{
    file_name <- paste("P_", "_005_1.pdf", sep = cell_type[i])

    pdf(file = file_name, width = 20, height = 20)

    par(mar = c(20, 20, 6.5, 1))

    par(mgp = c(3, 1.5, 0))

    par(cex.axis = 2.5)

    par(cex.lab = 2.5)

    par(cex.main = 5.5)

    par(bg = 0)

    file_name <- paste("p_", "_005.txt", sep = cell_type[i])

    data_p <- read.table(file_name, sep = "\t")

    data_p <- data_p[1:8,1:8]

    data_p <- -log10(data_p)

    data_p <- round(data_p, digits = 1)

    data_p_1 <- matrix(data = 0, nrow = 8, ncol = 8)

    data_p_1[data_p>=10] <- 4

    data_p_1[(data_p>=5)&(data_p<10)] <- 3

    data_p_1[(data_p>=2)&(data_p<5)] <- 2

    data_p_1[(data_p>=1)&(data_p<2)] <- 1

    data_p_1[data_p<1] <- 0

    data_p_1 <- t(data_p_1)

    data_p_1 <- data_p_1[,ncol(data_p_1):1]

    data_color <- colorpanel(5, "white", "red")

    image(1:nrow(data_p_1), 1:ncol(data_p_1), data_p_1, col = data_color, main = cell_type[i], xlab = "", ylab = "", axes = FALSE)

    for (j in 1:nrow(data_p))
    {
        for (k in 1:ncol(data_p))
        {
            text(k, 9-j, data_p[j,k], cex = 4)
        }
    }

    data_gene <- c("dnLoF-ASD", "dnLoF-Epi", "dnLoF-ID", "dnLoF-DD", "dnMis-ASD", "dnMis-Epi", "dnMis-ID", "dnMis-DD")

    data_gene_1 <- data_gene

    data_gene_1 <- data_gene_1[length(data_gene_1):1]

    par(cex.axis = 4)

    axis(1, 1:8, data_gene, las = 2)

    par(cex.axis = 4)

    axis(2, 1:8, data_gene_1, las = 2)

    dev.off()
}
