## Plot P values of co-expression enrichment analysis of eight NDD gene sets compared with the background genes in six major cortical cell types.

library(gplots)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("density_", "_005.txt", sep = cell_type[i])

    data_density <- read.table(file_name, sep = "\t")

    file_name <- paste("background_", "_005.txt", sep = cell_type[i])

    data_background <- scan(file_name, sep = "\t")

    data_p <- numeric(length = nrow(data_density))

    for (j in 1:nrow(data_density))
    {
        data_density_background <- matrix(data = NA, nrow = 2, ncol = 2)

        data_density_background[1,1] <- data_density[j,1]

        data_density_background[1,2] <- data_density[j,2]-data_density[j,1]

        data_density_background[2,1] <- data_background[1]

        data_density_background[2,2] <- data_background[2]-data_background[1]

        data_test <- fisher.test(data_density_background, alternative = "greater")

        data_p[j] <- data_test$p.value
    }

    file_name <- paste("p_", "_005_1.txt", sep = cell_type[i])

    write.table(data_p, file = file_name, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

for (i in 1:length(cell_type))
{
    file_name <- paste("P_", "_005.pdf", sep = cell_type[i])

    pdf(file = file_name, width = 20, height = 20)

    par(mar = c(29, 20, 6.5, 1))

    par(mgp = c(3, 1.5, 0))

    par(cex.axis = 2.5)

    par(cex.lab = 2.5)

    par(cex.main = 5.5)

    par(bg = 0)

    data_p <- matrix(data = NA, nrow = 8, ncol = 8)

    file_name <- paste("p_", "_005_1.txt", sep = cell_type[i])

    data_p_1 <- read.table(file_name, sep = "\t")

    data_p_1 <- -log10(data_p_1)

    data_p_1 <- round(data_p_1, digits = 1)

    data_p[,1] <- data_p_1[1:8,1]

    data_p_1 <- matrix(data = 0, nrow = 8, ncol = 8)

    data_p_1[data_p>=10] <- 4

    data_p_1[(data_p>=5)&(data_p<10)] <- 3

    data_p_1[(data_p>=2)&(data_p<5)] <- 2

    data_p_1[(data_p>=1)&(data_p<2)] <- 1

    data_p_1[data_p<1] <- 0

    data_p_1 <- t(data_p_1)

    data_p_1 <- data_p_1[,ncol(data_p_1):1]

    data_color <- colorpanel(5, "white", "red")

    image(1:nrow(data_p_1), 1:ncol(data_p_1), data_p_1, col = data_color, main = "", xlab = "", ylab = "", axes = FALSE)

    for (j in 1:nrow(data_p))
    {
        for (k in 1:ncol(data_p))
        {
            text(k, 9-j, data_p[j,k], cex = 4)
        }
    }

    par(cex.axis = 4)

    axis(1, 1, cell_type[i], las = 2)

    dev.off()
}
