## Plot expression of dnMis-Epi genes RANGAP1 and SCN2A in six major cortical cell types.

pdf(file = "expression_Epi_RANGAP1_SCN2A.pdf", width = 50, height = 10)

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

data_colour <- c(2, "darkgreen", "royalblue3", "cyan3", "hotpink", "orange")

split.screen(c(1,6))

for (i in 1:length(cell_type))
{
    screen(i)

    file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_expression_1 <- data_expression[data_expression[,1]==5905,]

    data_expression_1 <- data_expression_1[,2:ncol(data_expression_1)]

    data_expression_1 <- t(data_expression_1)

    data_expression_2 <- data_expression[data_expression[,1]==6326,]

    data_expression_2 <- data_expression_2[,2:ncol(data_expression_2)]

    data_expression_2 <- t(data_expression_2)

    if (i!=6)
    {
        data_rho <- numeric(length = 1000)

        set.seed(100000000)

        for (j in 1:1000)
        {
            data_column <- sample(1:nrow(data_expression_1), 68)

            data_column <- sort(data_column)

            data_rho[j] <- cor(data_expression_1[data_column], data_expression_2[data_column], method = "spearman")
        }

        data_rho_1 <- round(mean(data_rho), digits = 2)
    }else
    {
        data_rho_1 <- cor(data_expression_1, data_expression_2, method = "spearman")

        data_rho_1 <- round(data_rho_1, digits = 2)
    }

    par(mar = c(6, 6, 4.5, 1))

    par(mgp = c(3.5, 1, 0))

    par(cex.axis = 2.5)

    par(cex.lab = 2.5)

    par(cex.main = 3)

    plot(data_expression_1, data_expression_2, type = "p", pch = 19, xlim = c(0, 14), ylim = c(0, 12), main = cell_type[i], xlab = expression("RANGAP1 expression (log"[2]*"(TPM+1))"), ylab = expression("SCN2A expression (log"[2]*"(TPM+1))"), col = data_colour[i], cex = 2, axes = FALSE)

    axis(1, c(0:7*2), c(0:7*2), las = 1)

    axis(2, c(0:6*2), c(0:6*2), las = 2)

    data_rho_1 <- paste("rho", data_rho_1, sep = "=")

    text(12.5, 12, data_rho_1, cex = 2.5, col = 1)
}

close.screen(all = TRUE)

dev.off()
