## Co-expression enrichment analysis of NDD genes in six major cell types by controlling for expression level dependence.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:length(cell_type))
{
    file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_gene <- data_expression[,1]

    data_position <- 1:length(data_gene)

    data_position_1 <- data.frame(data_gene, data_position)

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    data_expression_1 <- t(data_expression_1)

    colnames(data_expression_1) <- data_position

    data_coexpression <- cor(data_expression_1, method = "spearman")

    data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

    data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

    data_coexpression_1 <- sort(data_coexpression_1, decreasing = TRUE)

## Calculate co-expression network threshold.

    data_threshold_position <- length(data_coexpression_1)*0.005

    data_threshold_position <- round(data_threshold_position, digits = 0)

    data_threshold <- data_coexpression_1[data_threshold_position]

    gene_set <- scan("../gene_set/gene_set.txt", what = "character", sep = "\t")

    gene_set <- gene_set[1:8]

    file_name_1 <- paste("../expression/", "/gene_bin_1.txt", sep = cell_type[i])

    data_gene_bin_1 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_2.txt", sep = cell_type[i])

    data_gene_bin_2 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_3.txt", sep = cell_type[i])

    data_gene_bin_3 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_4.txt", sep = cell_type[i])

    data_gene_bin_4 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_5.txt", sep = cell_type[i])

    data_gene_bin_5 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_6.txt", sep = cell_type[i])

    data_gene_bin_6 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_7.txt", sep = cell_type[i])

    data_gene_bin_7 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_8.txt", sep = cell_type[i])

    data_gene_bin_8 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_9.txt", sep = cell_type[i])

    data_gene_bin_9 <- scan(file_name_1, sep = "\t")

    file_name_1 <- paste("../expression/", "/gene_bin_10.txt", sep = cell_type[i])

    data_gene_bin_10 <- scan(file_name_1, sep = "\t")

    file_name_2 <- paste("score_expression_", "_005.txt", sep = cell_type[i])

    for (j in 1:length(gene_set))
    {
        file_name_3 <- paste("../gene_set/", ".txt", sep = gene_set[j])

        data_gene_1 <- read.table(file_name_3, sep = "\t")

        data_position_2 <- merge(data_position_1, data_gene_1, by = 1, sort = FALSE)

        data_position_3 <- data_position_2[,2]

        data_coexpression_2 <- data_coexpression[data_position_3,data_position_3]

        data_coexpression_3 <- data_coexpression_2[upper.tri(data_coexpression_2)]

        data_coexpression_3 <- data_coexpression_3[!is.na(data_coexpression_3)]

## Calculate co-expression fold enrichment score.

        data_coexpression_4 <- data_coexpression_3[data_coexpression_3>=data_threshold]

        data_score <- length(data_coexpression_4)/length(data_coexpression_3)

        data_gene_1 <- data_gene_1[,1]

        data_score_1 <- numeric(length = 1000)

        set.seed(100000000)

        for (k in 1:1000)
        {
            data_overlap <- intersect(data_gene_1, data_gene_bin_1)

            data_row_1 <- sample(data_gene_bin_1, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_2)

            data_row_2 <- sample(data_gene_bin_2, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_3)

            data_row_3 <- sample(data_gene_bin_3, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_4)

            data_row_4 <- sample(data_gene_bin_4, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_5)

            data_row_5 <- sample(data_gene_bin_5, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_6)

            data_row_6 <- sample(data_gene_bin_6, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_7)

            data_row_7 <- sample(data_gene_bin_7, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_8)

            data_row_8 <- sample(data_gene_bin_8, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_9)

            data_row_9 <- sample(data_gene_bin_9, length(data_overlap))

            data_overlap <- intersect(data_gene_1, data_gene_bin_10)

            data_row_10 <- sample(data_gene_bin_10, length(data_overlap))

            data_row <- c(data_row_1, data_row_2, data_row_3, data_row_4, data_row_5, data_row_6, data_row_7, data_row_8, data_row_9, data_row_10)

            data_row <- sort(data_row)

            data_position_2 <- merge(data_position_1, data_row, by = 1, sort = FALSE)

            data_position_3 <- data_position_2[,2]

            data_coexpression_2 <- data_coexpression[data_position_3,data_position_3]

            data_coexpression_3 <- data_coexpression_2[upper.tri(data_coexpression_2)]

            data_coexpression_3 <- data_coexpression_3[!is.na(data_coexpression_3)]

## Calculate co-expression fold enrichment score.

            data_coexpression_4 <- data_coexpression_3[data_coexpression_3>=data_threshold]

            data_score_1[k] <- length(data_coexpression_4)/length(data_coexpression_3)
        }

        data_score <- data_score/mean(data_score_1)

        write.table(data_score, file = file_name_2, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}
