## Co-expression enrichment analysis of GO biological process terms in NPCs calculated using Spearmans correlation.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

for (i in 1:1)
{
    file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    data_gene <- data_expression[,1]

    data_position <- 1:length(data_gene)

    data_position_1 <- data.frame(data_gene, data_position)

    data_expression_1 <- data_expression[,2:ncol(data_expression)]

    data_expression_1 <- t(data_expression_1)

    colnames(data_expression_1) <- data_position

    data_coexpression <- cor(data_expression_1, method = "spearman")

    data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

    data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

    data_coexpression_1 <- sort(data_coexpression_1, decreasing = TRUE)

## Calculate co-expression network threshold.

    data_threshold_position <- length(data_coexpression_1)*0.005

    data_threshold_position <- round(data_threshold_position, digits = 0)

    data_threshold <- data_coexpression_1[data_threshold_position]

## Adjust co-expression network density if there are ties of threshold.

    data_coexpression_2 <- data_coexpression_1[data_coexpression_1>=data_threshold]

    data_adjusted_density <- length(data_coexpression_2)/length(data_coexpression_1)

    data_background <- c(length(data_coexpression_2), length(data_coexpression_1))

    file_name_1 <- paste("background_GO_", "_Spearman.txt", sep = cell_type[i])

    write.table(t(data_background), file = file_name_1, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

    gene_set <- scan("GO_3.txt", what = "character", sep = "\t")

    file_name_2 <- paste("score_GO_", "_Spearman.txt", sep = cell_type[i])

    file_name_3 <- paste("density_GO_", "_Spearman.txt", sep = cell_type[i])

    for (j in 1:length(gene_set))
    {
        file_name_4 <- paste("./GO/", ".txt", sep = gene_set[j])

        file_name_4 <- gsub(":", "_", file_name_4)

        data_gene_1 <- read.table(file_name_4, sep = "\t")

        data_position_2 <- merge(data_position_1, data_gene_1, by = 1, sort = FALSE)

        data_position_3 <- data_position_2[,2]

        data_coexpression_3 <- data_coexpression[data_position_3,data_position_3]

        data_coexpression_4 <- data_coexpression_3[upper.tri(data_coexpression_3)]

        data_coexpression_4 <- data_coexpression_4[!is.na(data_coexpression_4)]

## Calculate co-expression fold enrichment score.

        data_coexpression_5 <- data_coexpression_4[data_coexpression_4>=data_threshold]

        data_score <- length(data_coexpression_5)/length(data_coexpression_4)/data_adjusted_density

        write.table(data_score, file = file_name_2, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

        data_density <- c(length(data_coexpression_5), length(data_coexpression_4))

        write.table(t(data_density), file = file_name_3, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}

gene_set <- scan("GO_3.txt", what = "character", sep = "\t")

data_score <- scan("score_GO_NPCs_Spearman.txt", what = "character", sep = "\t")

data_score_1 <- data.frame(gene_set, data_score)

write.table(data_score_1, file = "score_GO_NPCs_Spearman_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_GO <- read.table("../GO_overlap/GO.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

data_score <- read.table("score_GO_NPCs_Spearman_1.txt", sep = "\t", colClasses = "character")

data_score_1 <- merge(data_GO, data_score, by = 1, all.y = TRUE)

write.table(data_score_1, file = "score_GO_NPCs_Spearman_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
