## Co-expression enrichment analysis of dnMis-Epi genes in interneurons at varying co-expression thresholds.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[3])

data_expression <- read.table(file_name, sep = "\t")

data_gene <- data_expression[,1]

data_position <- 1:length(data_gene)

data_position_1 <- data.frame(data_gene, data_position)

data_expression_1 <- data_expression[,2:ncol(data_expression)]

data_expression_1 <- t(data_expression_1)

colnames(data_expression_1) <- data_position

data_coexpression <- cor(data_expression_1, method = "spearman")

data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

data_coexpression_1 <- sort(data_coexpression_1, decreasing = TRUE)

## Calculate co-expression network thresholds at varying top percentage.

threshold_value <- c(1:10/1000, 2:5/100)

for (i in 1:length(threshold_value))
{
    data_threshold_position <- length(data_coexpression_1)*threshold_value[i]

    data_threshold_position <- round(data_threshold_position, digits = 0)

    data_threshold <- data_coexpression_1[data_threshold_position]

## Adjust co-expression network density if there are ties of threshold.

    data_coexpression_2 <- data_coexpression_1[data_coexpression_1>=data_threshold]

    data_adjusted_density <- length(data_coexpression_2)/length(data_coexpression_1)

    gene_set <- scan("../gene_set/gene_set.txt", what = "character", sep = "\t")

    file_name_2 <- paste("../gene_set/", ".txt", sep = gene_set[6])

    data_gene_1 <- read.table(file_name_2, sep = "\t")

    data_position_2 <- merge(data_position_1, data_gene_1, by = 1, sort = FALSE)

    data_position_3 <- data_position_2[,2]

    data_coexpression_3 <- data_coexpression[data_position_3,data_position_3]

    data_coexpression_4 <- data_coexpression_3[upper.tri(data_coexpression_3)]

    data_coexpression_4 <- data_coexpression_4[!is.na(data_coexpression_4)]

## Calculate co-expression fold enrichment score.

    data_coexpression_5 <- data_coexpression_4[data_coexpression_4>=data_threshold]

    data_score <- length(data_coexpression_5)/length(data_coexpression_4)/data_adjusted_density

    data_score_1 <- c(threshold_value[i], data_score)

    write.table(t(data_score_1), file = "score_Epi.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}
