## Spearmans correlation analysis of NDD genes in six major cell types by downsampling.

cell_type <- scan("../expression/sample_id_9.txt", what = "character", sep = "\t")

cell_type <- cell_type[1:5]

for (i in 1:length(cell_type))
{
    file_name <- paste("../expression/", "/GSE_8.txt", sep = cell_type[i])

    data_expression <- read.table(file_name, sep = "\t")

    gene_set <- scan("../gene_set/gene_set.txt", what = "character", sep = "\t")

    gene_set <- gene_set[1:8]

    file_name_1 <- paste("cor_", ".txt", sep = cell_type[i])

    for (j in 1:length(gene_set))
    {
        file_name_2 <- paste("../gene_set/", ".txt", sep = gene_set[j])

        data_gene <- read.table(file_name_2, sep = "\t")

        data_expression_1 <- merge(data_expression, data_gene, by = 1)

        data_expression_2 <- data_expression_1[,2:ncol(data_expression_1)]

        data_cor <- numeric(length = 1000)

        set.seed(100000000)

        for (k in 1:1000)
        {
            data_column <- sample(1:ncol(data_expression_2), 68)

            data_column <- sort(data_column)

            data_expression_3 <- data_expression_2[,data_column]

            data_expression_3 <- t(data_expression_3)

            data_coexpression <- cor(data_expression_3, method = "spearman")

            data_coexpression_1 <- data_coexpression[upper.tri(data_coexpression)]

            data_coexpression_1 <- data_coexpression_1[!is.na(data_coexpression_1)]

            data_cor[k] <- mean(data_coexpression_1)
        }

        write.table(t(data_cor), file = file_name_1, append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
    }
}
