## GO enrichment analysis of dnMis-Epi genes during the vRG-to-IPC transition at GW10.

data_gene <- scan("../expression/NPCs/gene_T_1.txt", what = "character", sep = "\t")

data_gene_1 <- scan("../gene_set/dnMis-Epi.txt", what = "character", sep = "\t")

data_intersect <- intersect(data_gene, data_gene_1)

data_intersect <- sort(data_intersect)

write.table(data_intersect, file = "gene_Epi.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_gene <- scan("gene_Epi.txt", what = "character", sep = "\t")

data_term <- scan("GO_3.txt", what = "character", sep = "\t")

for (i in 1:length(data_term))
{
    file_name <- paste("./GO/", ".txt", sep = data_term[i])

    file_name <- gsub(":", "_", file_name)

    data_GO <- scan(file_name, what = "character", sep = "\t")

    data_intersect <- intersect(data_gene, data_GO)

    data_union <- union(data_gene, data_GO)

    data_intersect_union <- matrix(data = NA, nrow = 2, ncol = 2)

    data_intersect_union[1,1] <- length(data_intersect)

    data_intersect_union[1,2] <- length(data_gene)-length(data_intersect)

    data_intersect_union[2,1] <- length(data_GO)-length(data_intersect)

    data_intersect_union[2,2] <- 11017-length(data_union)

    data_test <- fisher.test(data_intersect_union, alternative = "greater")

    data_or <- data_test$estimate

    data_p <- data_test$p.value

    data_size <- length(data_intersect)

    data_size_1 <- length(data_GO)

    data_ratio <- length(data_intersect)/length(data_GO)

    data_size_2 <- length(data_gene)

    data_ratio_1 <- length(data_intersect)/length(data_gene)

    data_GO_1 <- c(data_term[i], data_or, data_p, data_size, data_ratio, data_size_1, data_ratio_1, data_size_2)

    write.table(t(data_GO_1), file = "overlap_Epi.txt", append = TRUE, quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
}

data_GO <- read.table("overlap_Epi.txt", sep = "\t")

data_p <- data_GO[,3]

data_fdr <- p.adjust(data_p, method = "BH")

data_GO_1 <- data.frame(data_GO[,1:2], data_fdr, data_GO[,3:ncol(data_GO)])

write.table(data_GO_1, file = "overlap_Epi_1.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)

data_GO <- read.table("GO.txt", sep = "\t", quote = "", colClasses = "character", comment.char = "")

data_GO_1 <- read.table("overlap_Epi_1.txt", sep = "\t", colClasses = "character")

data_GO_2 <- merge(data_GO, data_GO_1, by = 1, all.y = TRUE)

write.table(data_GO_2, file = "overlap_Epi_2.txt", quote = FALSE, sep = "\t", row.names = FALSE, col.names = FALSE)
