## Plot GO enrichment and negative correlation analyses of dnLoF-ASD genes during the vRG-to-IPC transition at GW10.

pdf(file = "GO_overlap_ASD.pdf", width = 10, height = 10)

data_GO <- read.table("GO_overlap_ASD_7.txt", sep = "\t", quote = "", comment.char = "")

data_GO_1 <- read.table("GO_overlap_ASD_8.txt", sep = "\t", quote = "", comment.char = "")

data_GO_2 <- read.table("GO_overlap_ASD_9.txt", sep = "\t", quote = "", comment.char = "")

## data_GO_3 <- read.table("GO_overlap_ASD_10.txt", sep = "\t", quote = "", comment.char = "")

data_GO_4 <- read.table("GO_overlap_ASD_11.txt", sep = "\t", quote = "", comment.char = "")

data_GO_5 <- read.table("GO_overlap_ASD_12.txt", sep = "\t", quote = "", comment.char = "")

data_GO_5[,5] <- gsub("\"", "", data_GO_5[,5])

## data_GO_6 <- read.table("GO_overlap_ASD_13.txt", sep = "\t", quote = "", comment.char = "")

par(mar = c(6, 6, 4.5, 1))

par(mgp = c(3.5, 1, 0))

par(cex.axis = 2.5)

par(cex.lab = 2)

par(cex.main = 3)

plot(data_GO[,1], data_GO[,2], type = "p", pch = 19, xlim = c(0, 5), ylim = c(0, 32), main = "ASD, vRG -> IPCs (GW10)", xlab = expression("GO enrichment with dnLoF-ASD (-log"[10]*"FDR)"), ylab = expression("GO negative correlation with dnLoF-ASD (-log"[10]*"FDR)"), col = "gray60", cex = 1, axes = FALSE)

points(data_GO_1[,1], data_GO_1[,2], type = "p", pch = 19, col = "darkgreen", cex = 1.5)

points(data_GO_2[,1], data_GO_2[,2], type = "p", pch = 19, col = 4, cex = 1.5)

## points(data_GO_3[,1], data_GO_3[,2], type = "p", pch = 19, col = 2, cex = 1.5)

axis(1, c(0:5), c(0:5), las = 1)

axis(2, c(0:8*4), c(0:8*4), las = 2)

lines(c(0, 5), c(4, 4), lty = 2, lwd = 2)

lines(c(2, 2), c(0, 32), lty = 2, lwd = 2)

for (i in 1:nrow(data_GO_4))
{
    lines(c(data_GO_4[i,1], data_GO_4[i,3]), c(data_GO_4[i,2], data_GO_4[i,4]), col = "gray60", lty = 1, lwd = 3)
}

for (i in 1:nrow(data_GO_5))
{
    lines(c(data_GO_5[i,1], data_GO_5[i,3]), c(data_GO_5[i,2], data_GO_5[i,4]), col = "gray60", lty = 1, lwd = 3)
}

## for (i in 1:nrow(data_GO_6))
## {
##     lines(c(data_GO_6[i,1], data_GO_6[i,3]), c(data_GO_6[i,2], data_GO_6[i,4]), col = "gray60", lty = 1, lwd = 3)
## }

for (i in 1:nrow(data_GO_4))
{
    text(data_GO_4[i,3], data_GO_4[i,4], data_GO_4[i,5], col = "darkgreen", cex = 2)
}

for (i in 1:nrow(data_GO_5))
{
    text(data_GO_5[i,3], data_GO_5[i,4], data_GO_5[i,5], col = 4, cex = 2)
}

## for (i in 1:nrow(data_GO_6))
## {
##     text(data_GO_6[i,3], data_GO_6[i,4], data_GO_6[i,5], col = 2, cex = 2)
## }

dev.off()
